/**************************************************************************//**
 * \file       clSDS_PreviousDestinationsList.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_PreviousDestinationsList_h
#define clSDS_PreviousDestinationsList_h


#include <string>
#include <vector>

#include "application/clSDS_List.h"
#include <application/clSDS_NaviList.h>
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/NaviAddressFormatter.h"

class GuiService;
class clSDS_PreviousDestinationsList : public clSDS_List
   , public clSDS_NaviList
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryCallbackIF
   , public org::bosch::cm::navigation::NavigationService::StartGuidanceCallbackIF
   , public org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedCallbackIF
   , public org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationCallbackIF
{
   public:
      virtual ~clSDS_PreviousDestinationsList();
      clSDS_PreviousDestinationsList(
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > ponaviProxy,
         NaviAddressFormatter* pNaviAddressFormatter,
         GuiService* pGuiService);
      tBool bSelectElement(tU32 u32SelectedIndex);
      tU32 u32GetSize();
      std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);

      virtual void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onRequestDestinationMemoryEntriesError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesError >& error);

      virtual void onRequestDestinationMemoryEntriesResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesResponse >& response);

      // Call back function form StartGuidanceToLastDestinationCallbackIF
      virtual void onStartGuidanceError(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
                                        const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceError >& error);

      virtual void onStartGuidanceResponse(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
                                           const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceResponse >& response);

      virtual void onIsLastDestinationListChangedError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedError >& error);

      virtual void onIsLastDestinationListChangedUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedUpdate >& update);

      virtual void onSetLocationWithDestinationMemoryEntryError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryError >& error);

      virtual void onSetLocationWithDestinationMemoryEntryResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryResponse >& response);
      virtual void onRequestDetailsForSelectedLocationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationError >& error);
      virtual void onRequestDetailsForSelectedLocationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse >& response);

   private:
      std::string oGetItem(tU32 u32Index);
      tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType);
      virtual std::vector<sds2hmi_fi_tcl_HMIElementDescrptionList> getHmiListDescription();
      std::vector<sds2hmi_fi_tcl_HMIElementDescription>  getHmiElementDescription(unsigned int);
      unsigned long vGetPreviousDestinationIndex()const;
      void oClearPreviousDestinationListItems();
      void oSetPreviousDestinationListCount(unsigned long previousDestinationList);
      void oSetPreviousDestinationIndex(unsigned long previousDestinationPOI);
      bool isUserWordAddress(const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement& address);
      std::string getFormattedAddress(const ::std::vector <std::string> currentCountryAddressFormat);
      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _naviProxy;
      NaviAddressFormatter* _pNaviAddressFormatter;
      GuiService* _pGuiService;
      unsigned long _previousDestinationCount;
      unsigned long _previousDestinationPOIIndexValue;
      std::vector< org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement > _previousDestinations;
      void vStartGuidance();
      void sendDestinationMemoryEntryIdToNavi(tU32 selectedIndex);
      bool _isLastDestinationListChanged;
      bool _isInitialRequest;
      std::map < std::string, std::vector <std::string> > _countryAddressFormat;
      std::map <org::bosch::cm::navigation::NavigationService::DestinationMemoryAddressType, std::string> _addressDetailsItemStringList;
      std::map <org::bosch::cm::navigation::NavigationService::DestinationMemoryAddressType, std::string> _addressDetailsItemPhonemeList;
      void setAddressDetails(const std::vector< org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem>& destinationMemoryEntryItemList);
};


#endif
