/**************************************************************************//**
 * \file       clSDS_ParkingList.h
 *
 * Handles audio channel requests from the prompt player.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef clSDS_ParkingList_h
#define clSDS_ParkingList_h

#include "application/clSDS_List.h"
#include "application/clSDS_NaviList.h"
#include "application/DistanceDirectionUtility.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "sxm_parking_main_fiProxy.h"
#include "VEHICLE_MAIN_FIProxy.h"

class GuiService;

class clSDS_ParkingList
   : public clSDS_List
   , public asf::core::ServiceAvailableIF
   , public sxm_parking_main_fi::GetParkingInfoListCallbackIF
   , public VEHICLE_MAIN_FI::DistanceUnitCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsCallbackIF
   , public org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationCallbackIF
   , public org::bosch::cm::navigation::NavigationService::StartGuidanceCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoCallbackIF
   , public clSDS_NaviList
{
   public:
      virtual ~clSDS_ParkingList();
      clSDS_ParkingList(
         boost::shared_ptr< sxm_parking_main_fi::Sxm_parking_main_fiProxy > sxmParkingProxy,
         boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy,
         boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > naviSDSProxy,
         boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy > vehicleFiProxy,
         GuiService* pGuiService);

      tU32 u32GetSize();
      std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      tBool bSelectElement(tU32 u32SelectedIndex);

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onGetParkingInfoListError(
         const ::boost::shared_ptr< sxm_parking_main_fi::Sxm_parking_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_parking_main_fi::GetParkingInfoListError >& error);

      virtual void onGetParkingInfoListResult(
         const ::boost::shared_ptr< sxm_parking_main_fi::Sxm_parking_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_parking_main_fi::GetParkingInfoListResult >& result);

      virtual void onDistanceUnitError(
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::DistanceUnitError >& error);

      virtual void onDistanceUnitStatus(
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::DistanceUnitStatus >& status);

      virtual void onSetLocationWithDetailsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsError >& error) ;

      virtual void onSetLocationWithDetailsResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsResponse >& response);

      virtual void onRequestDetailsForSelectedLocationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationError >& error);

      virtual void onRequestDetailsForSelectedLocationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse >& response);

      virtual void onStartGuidanceError(
         const ::boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy>& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceError >& error);

      virtual void onStartGuidanceResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceResponse >& response);

      virtual void onPositionStatusInfoError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoError >& error);

      virtual void onPositionStatusInfoUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoUpdate >& update);

   private:
      struct stParkingListItems
      {
         std::string parkingStationName;
         std::string cityName;
         std::string stateName;
         std::string distanceWithUnits;
         std::string parkingStationAddress;
         std::string parkingStationPhoneNumber;
         double longitude;
         double  latitude;
         int direction;
      };

      tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType);
      clSDS_ListItems getListItem(tU32 u32Index) const;
      std::string getParkingStationName(tU32 u32Index)const;
      std::string getDistance(tU32 u32Index)const;
      int getDirection(tU32 u32Index)const;
      std::string getParkingStationAddress(tU32 u32Index)const;
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);

      void setParkingListItems(const std::vector< sxm_parking_main_fi_types::T_ParkingInfo >& lParkingList);
      void sendParkingLocationDetailsToNavi(unsigned long index);
      void vStartGuidance();

      std::vector<stParkingListItems> _parkingListItems;
      boost::shared_ptr< sxm_parking_main_fi::Sxm_parking_main_fiProxy > _sxmParkingProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _naviProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _naviSDSProxy;
      boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy > _vehicleFiProxy;
      GuiService* _pGuiService;
      DistanceDirectionUtility::enDistanceUnitType _vehicleDistanceUnits;
      double _startvehicleheading;
      org::bosch::cm::navigation::NavigationService:: PositionWGS84 _naviGeoPosition;
};


#endif
