/**************************************************************************//**
 * \file       clSDS_POIList.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_POIList_h
#define clSDS_POIList_h


#include "application/clSDS_List.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/RestoreHMIList.h"
#include "application/clSDS_ConfigurationFlags.h"
#include <string>
#include <vector>


class clSDS_POIList : public clSDS_List
   , public asf::core::ServiceAvailableIF
   , public RestoreHMIList
   , public org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsCallbackIF
   , public org::bosch::cm::navigation::NavigationService::UndoFreeTextSearchElementSelectionCallbackIF
   , public org::bosch::cm::navigation::NavigationService::UndoSetLocationWithFixedPOICategoryInputCallbackIF
{
   public:
      virtual ~clSDS_POIList();
      clSDS_POIList(::boost::shared_ptr< org::bosch::cm::navigation::NavigationService:: NavigationServiceProxy > naviProxy);
      virtual void onSdsPOICategoryShortcutsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsError >& error);
      virtual void onSdsPOICategoryShortcutsUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsUpdate >& update);
      virtual void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      virtual void onUndoFreeTextSearchElementSelectionError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::UndoFreeTextSearchElementSelectionError >& error);
      virtual void onUndoFreeTextSearchElementSelectionResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::UndoFreeTextSearchElementSelectionResponse >& response);
      virtual void onUndoSetLocationWithFixedPOICategoryInputError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::UndoSetLocationWithFixedPOICategoryInputError >& error);
      virtual void onUndoSetLocationWithFixedPOICategoryInputResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::UndoSetLocationWithFixedPOICategoryInputResponse >& response);
      tU32 u32GetSize();
      std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      tBool bSelectElement(tU32 u32SelectedIndex);
      tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType);
      void setPOIList(const std::vector< org::bosch::cm::navigation::NavigationService::AddressListElement >& oPOIList);
      tU32 getRefinementID(tU32 absoluteValue);
      void setHandOverPOIList(const std::vector< org::bosch::cm::navigation::NavigationService::AddressListElement >& oPOIList);
      void vRestoreHMIListData();
      void setPOIListViaHaptic();
      void resetPOIListViaHaptic();
      bool getResultType();
      bool isPOIListViaHaptic();

   private:
      enum enHeadingType
      {
         EN_HEADING_INDEX_UNKNOWN         = -1,
         EN_HEADING_INDEX_NORTH           = 0,
         EN_HEADING_INDEX_NORTH_EAST      = 1,
         EN_HEADING_INDEX_EAST            = 2,
         EN_HEADING_INDEX_SOUTH_EAST      = 3,
         EN_HEADING_INDEX_SOUTH           = 4,
         EN_HEADING_INDEX_SOUTH_WEST      = 5,
         EN_HEADING_INDEX_WEST            = 6,
         EN_HEADING_INDEX_NORTH_WEST      = 7,
      };

      enum GRAMMAR_ID_INDEX
      {
         GRAMMAR_ID_RESTAURANT = 1,
         GRAMMAR_ID_GAS_STATION ,
         GRAMMAR_ID_ATM ,
         GRAMMAR_ID_COFFEEPUB ,
         GRAMMAR_ID_CONVENIENCE ,
         GRAMMAR_ID_PARKING ,
         GRAMMAR_ID_GROCERY_STORE ,
         GRAMMAR_ID_HOTEL ,
      };

      std::string oGetItem(tU32 u32Index);
      std::string oGetDisatance(tU32 u32Index);
      clSDS_ListItems oGetListItem(tU32 u32Index);
      signed char oGetDirectionFromMapping(tU32 u32Index)const;
      std::vector<org::bosch::cm::navigation::NavigationService::AddressListElement > _poiList;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _naviProxy;
      std::vector< org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut > _sdsPOICategory;
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);
      bool _restoreHMIListResponse;
      bool _POIListViaHaptic;
};


#endif
