/**************************************************************************//**
 * \file       clSDS_MyAppsDataBase.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_MyAppsDataBase_h
#define clSDS_MyAppsDataBase_h


#include <string>
#include <vector>


#ifdef SQL_SUPPORTED
#define SQL_S_IMPORT_INTERFACE_CLIENT
#include "sql_if.h"

#define SQLDB_S_IMPORT_INTERFACE_BASE
#define SQLDB_S_IMPORT_INTERFACE_NOTRACE
#include "sqldb_if.h"
#endif

#include "external/sds2hmi_fi.h"


class clSDS_MyAppsDataBaseObserver;


struct stMyappNames
{
   std::string oAppName;
   std::string oLanguageId;
};


#ifdef SQL_SUPPORTED
class clSDS_MyAppsDataBase : public sql::Client
#else
class clSDS_MyAppsDataBase
#endif
{
   public:
      virtual ~clSDS_MyAppsDataBase();
      clSDS_MyAppsDataBase();
      virtual tS32 answer(tS32 s32NumOfEntry, tChar** vals, tChar** cols, tU32 arg);
      tVoid vRegisterObserver(clSDS_MyAppsDataBaseObserver* pObserver);
      std::vector<stMyappNames> oGetMyAppsNameList() const;
      tVoid vRequestMyAppsNames();
      tBool bOpenMyAppsDataBase() const;
      tVoid vReadMyAppsDataBase() const;
      tVoid vClearMyAppsList();

   private:
      OSAL_tThreadID _hThread;
      tVoid vRequestAppsNamefromDataBase() const;
      tVoid vCreateThreadToReadMyAppsDataBase();
      std::vector<clSDS_MyAppsDataBaseObserver*> _observers;
      std::vector<stMyappNames> _oMyAppsNameList;
      tVoid vNotifyObservers();
};


#endif
