/**************************************************************************//**
 * \file       clSDS_ListScreen.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_ListScreen_h
#define clSDS_ListScreen_h


#include <string>
#include <vector>


#include "application/clSDS_List.h"
#include "application/clSDS_ScreenData.h"


class clSDS_ListScreen
{
   public:
      ~clSDS_ListScreen();
      clSDS_ListScreen();

      tBool bIsListScreen(std::string screenId);
      tVoid vSetCurrentList(std::string screenId);
      tVoid setMaxItemsPerPage(tU32 itemsPerPage);
      tVoid vResetPageNumber();
      tVoid vIncrementPageNumber();
      tVoid vDecrementPageNumber();
      std::vector<clSDS_ListItems> vGetListScreenContents(const clSDS_ScreenData& oScreenData, const sds2hmi_fi_tcl_e8_PopUp_UpdateType& updateType);
      tVoid vSetListScreenContents(std::vector<clSDS_ListItems> listItems);
      tBool bHasPreviousPage() const;
      tBool bHasNextPage() const;
      tU8 getNumOfElementsOnCurrentPage() const;
      tVoid vAddToList(std::string screenId, clSDS_List* pList);
      tU32 u32GetPageNumber() const;
      tBool bSelectElement(tU32 u32SelectedIndex);
      std::string oGetSelectedItem(tU32 u32Index);
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);
      unsigned short int getListItemsSize();
      unsigned int getMaxElementsPerPage();

   private:
      clSDS_List* _pCurrentList;
      clSDS_List* _pLastList;
      std::map<std::string, clSDS_List*> _oListMap;
};


#endif
