/**************************************************************************//**
 * \file       clSDS_ListItems.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_ListItems_h
#define clSDS_ListItems_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <string>


class clSDS_ListItems
{
   public:
      enum tenColorofText
      {
         NORMAL = 0,
         COMMAND,
         SELECTED,
         GREYED_OUT,
         PRICE_AGE_CURRENT,
         PRICE_AGE_1_DAY,
         PRICE_AGE_2_DAYS,
         PRICE_AGE_3_DAYS_PLUS
      };

      tBool bIsListScreenWithoutIndex;

      struct stColumn
      {
         stColumn() : enTextColor(NORMAL) {}
         std::string szString;
         tenColorofText enTextColor;
      };

      virtual ~clSDS_ListItems();
      clSDS_ListItems();

      stColumn oCommand;
      stColumn oDescription;
      stColumn oDistance;
      stColumn oDirectionSymbol;
      stColumn oPrice;
      stColumn oLastPriceUpdate;
      stColumn oMessage;
      stColumn oTime;
      stColumn oIcon;
      stColumn oIcon2;
};


#endif
