/**************************************************************************//**
 * \file       clSDS_KDSConfiguration.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef clSDS_KDSConfiguration_h
#define clSDS_KDSConfiguration_h


#include <string>


class clSDS_KDSConfiguration
{
   public:

      enum Country
      {
         USA,
         CAN,
         MEX,
         UK ,
         TKY,
         RUS,
         OTHER_EUR,
         PRC,
         TWN,
         HKG_MACAU,
         GCC,
         EGP,
         ASR_NZR,
         BRA,
         AGT,
         OTHER_LAC,
         SAF,
         THI,
         SGP,
         MLY,
         BRN,
         INN,
         VNM,
         PHL,
         IND,
         JPN,
         KOR,
         OTHER_GOM,
         ISR
      };

      enum AllianceVoiceRecognitionModeType
      {
         OFF,
         BEGINNER,
         EXPERT
      };

      enum AllianceVehicleFleetType
      {
         DEFAULT,
         TAXI,
         AMBULANCE
      };

      enum AllianceFuelConsumptionType
      {
         Fuel_Consumption_Type_OFF = 0,
         Display_Bar_Graph,
         Display_Numeric_Number,
         Reserved
      };

      enum AllianceHVACTemperatureType
      {
         Temperature_Unit_Celcius = 1,
         Temperature_Unit_Fahrenheit
      };

      enum VehicleDistanceUnitType
      {
         EN_DIST_US_MILES_AND_KM,
         EN_DIST_KM_ONLY,
         EN_DIST_UK_MILES_AND_KM,
         EN_DIST_RESERVED
      };

      enum SystemVariant
      {
         EN_NOT_CONFIGURED,
         EN_ENTRY_NAVIGATION,
         EN_ENTRY_DISPLAY_AUDIO,
         EN_MID_NAVIGATION,
         EN_MID_DISPLAY_AUDIO,
         EN_GENERIC_NAVIGATION,
         EN_EVOBUS_NAVIGATION
      };

      enum FuelType
      {
         PETROL,
         DIESEL,
         HYBRID_DIESEL,
         HYBRID_PETROL,
         ELECTRICITY
      };

      enum OEMType
      {
         TYPE_RENAULT = 8,
         TYPE_NISSAN  = 6,
         TYPE_DAIMLER = 16,
         TYPE_INFINITI  = 22
      };
      enum DisplayOrientation
      {
         LANDSCAPE,
         PORTARIT
      };

      enum VariantSelectionType
      {
         EN_VARIANT_SELECTION_TYPE_NOT_CONFIGURED,
         EN_VARIANT_SELECTION_TYPE_NAVIGATION,
         EN_VARIANT_SELECTION_TYPE_DISPLAY_AUDIO
      };

      enum SystemTypeSelector
      {
         EN_SYSTEM_TYPE_SELECTOR_ENTRY,
         EN_SYSTEM_TYPE_SELECTOR_MID,
         EN_SYSTEM_TYPE_SELECTOR_HIGH,
         EN_SYSTEM_TYPE_SELECTOR_GENERIC,
         EN_SYSTEM_TYPE_SELECTOR_EVOBUS
      };

      enum AutoBargeInState
      {
         STATE_OFF = 0,
         STATE_ON_FEEDBACK_INSIDE_PCB = 1,
         STATE_ON_FEEDBACK_OUT = 2,
         STATE_RESERVED = 3
      };

      clSDS_KDSConfiguration();
      virtual ~clSDS_KDSConfiguration();

      static unsigned char getKDSConfigGeneric(const std::string& strConfigElement, const std::string& strConfigItem, unsigned char configValue = 0x00);

      static Country getMarketRegionType();

      static unsigned char getDABMounted();
      static unsigned char getDABEnabled();
      static unsigned char getXMTunerMounted();
      static unsigned char getDTVMounted();
      static unsigned char getHEVInformationFunction();
      static unsigned char getBluetoothPhoneEnabled();
      static unsigned char getRDSAudioTuner1();
      static unsigned char getPIIgnore();
      static unsigned char getCDMounted();
      static unsigned char getDVDMounted();

      static unsigned char getMaintenanceInfo();
      static unsigned char getFuelConsumptionInfo();

      static AllianceVoiceRecognitionModeType getAllianceVRModeType();
      static AllianceVehicleFleetType getAllianceVehicleFleetType();
      static unsigned char getVRBeep();
      static unsigned char getVRShortPrompts();
      static FuelType getVehicleEngineType();
      static VehicleDistanceUnitType getVehicleDistanceUnitsType();
      static SystemVariant getSystemVariant();

      static OEMType getVariantType();
      static DisplayOrientation getDisplayOrientation();
      static AutoBargeInState getAutoBargeIn();
      static  unsigned char getDefaultLanguage();
      static unsigned char getAllianceHVACTemperatureType();
      static unsigned char getSIRI();
      static unsigned char getVoiceAssistant();
      static unsigned char getCarplay();
      static unsigned char getAndroidAuto();

   private:
      static SystemTypeSelector getSystemTypeSelector();
      static VariantSelectionType getVariantSelectionType();
};


#endif
