/**************************************************************************//**
 * \file       clSDS_IsVehicleMoving.cpp
 *
 * clSDS_IsVehicleMoving class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "application/clSDS_IsVehicleMoving.h"
#include "application/clSDS_IsVehicleMovingObserver.h"


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_IsVehicleMoving::~clSDS_IsVehicleMoving()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_IsVehicleMoving::clSDS_IsVehicleMoving()
{
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_IsVehicleMoving::vRegisterObserver(clSDS_IsVehicleMovingObserver* pObserver)
{
   if (pObserver != NULL)
   {
      _observers.push_back(pObserver);
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_IsVehicleMoving::vNotifyObservers()
{
   std::vector<clSDS_IsVehicleMovingObserver*>::iterator iter = _observers.begin();
   while (iter != _observers.end())
   {
      if (*iter != NULL)
      {
         (*iter)->vVehicleSpeedChanged();
      }
      ++iter;
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_IsVehicleMoving::vOnVehicleSpeedChange()
{
   vNotifyObservers();
}
