/**************************************************************************//**
 * \file       clSDS_InfoFeedsList.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_InfoFeedsList_h
#define clSDS_InfoFeedsList_h


#include "application/clSDS_List.h"
#include "tcu_usb_main_fiProxy.h"


class clSDS_InfoFeedsList
   : public clSDS_List
   , public tcu_usb_main_fi::ReadFavoriteFeedsCallbackIF
   , public tcu_usb_main_fi::SelectFavoriteFeedsCallbackIF
{
   public:
      virtual ~clSDS_InfoFeedsList();
      clSDS_InfoFeedsList(::boost::shared_ptr< tcu_usb_main_fi::Tcu_usb_main_fiProxy> tcuUsbMainProxy);

      tU32 u32GetSize();
      std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      tBool bSelectElement(tU32 u32SelectedIndex);

      virtual void onReadFavoriteFeedsError(
         const ::boost::shared_ptr< tcu_usb_main_fi::Tcu_usb_main_fiProxy >& proxy,
         const ::boost::shared_ptr< tcu_usb_main_fi::ReadFavoriteFeedsError >& error);

      virtual void onReadFavoriteFeedsResult(
         const ::boost::shared_ptr< tcu_usb_main_fi::Tcu_usb_main_fiProxy >& proxy,
         const ::boost::shared_ptr< tcu_usb_main_fi::ReadFavoriteFeedsResult >& result);

      virtual void onSelectFavoriteFeedsError(
         const ::boost::shared_ptr< tcu_usb_main_fi::Tcu_usb_main_fiProxy >& proxy,
         const ::boost::shared_ptr< tcu_usb_main_fi::SelectFavoriteFeedsError >& error);
      virtual void onSelectFavoriteFeedsResult(
         const ::boost::shared_ptr< tcu_usb_main_fi::Tcu_usb_main_fiProxy >& proxy,
         const ::boost::shared_ptr< tcu_usb_main_fi::SelectFavoriteFeedsResult >& result);

   private:
      tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType);
      std::string oGetItem(tU32 u32Index);
      std::vector<sds2hmi_fi_tcl_HMIElementDescrptionList> getHmiListDescription();
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);
      boost::shared_ptr< tcu_usb_main_fi::Tcu_usb_main_fiProxy> _tcuUsbMainProxy;
      tcu_usb_main_fi_types::T_usb_tcu_Favorite_Feed_List _infoFavoriteFeedsList;
};


#endif
