/**************************************************************************//**
 * \file       clSDS_InfoFeedsList.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/clSDS_InfoFeedsList.h"

using namespace tcu_usb_main_fi;
using namespace tcu_usb_main_fi_types;


/**************************************************************************//**
 *
 ******************************************************************************/
clSDS_InfoFeedsList ::~clSDS_InfoFeedsList()
{
}


clSDS_InfoFeedsList:: clSDS_InfoFeedsList(
   ::boost::shared_ptr< Tcu_usb_main_fiProxy> tcuUsbMainProxy)
   : _tcuUsbMainProxy(tcuUsbMainProxy)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
tVoid clSDS_InfoFeedsList::vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType)
{
   if (listType == sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_INFO_FEEDS && _tcuUsbMainProxy ->isAvailable())
   {
      _tcuUsbMainProxy->sendReadFavoriteFeedsStart(*this);
   }
   else
   {
      _infoFavoriteFeedsList.clear();
      notifyListObserver();
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_InfoFeedsList::onReadFavoriteFeedsError(
   const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& /*proxy*/,
   const ::boost::shared_ptr< ReadFavoriteFeedsError >& /*error*/)
{
   _infoFavoriteFeedsList.clear();
   notifyListObserver();
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_InfoFeedsList::onReadFavoriteFeedsResult(
   const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& /*proxy*/,
   const ::boost::shared_ptr< ReadFavoriteFeedsResult >& result)
{
   _infoFavoriteFeedsList.clear();

   if (result->hasFavorite_Feed_List())
   {
      _infoFavoriteFeedsList = result->getFavorite_Feed_List();
   }

   notifyListObserver();
}


/**************************************************************************//**
 *
 ******************************************************************************/
tU32 clSDS_InfoFeedsList::u32GetSize()
{
   return static_cast <tU32>(_infoFavoriteFeedsList.size());
}


/**************************************************************************//**
 *
 ******************************************************************************/
std::vector<clSDS_ListItems> clSDS_InfoFeedsList::oGetItems(tU32 u32StartIndex, tU32 u32EndIndex)
{
   std::vector<clSDS_ListItems> oListItems;
   for (tU32 u32Index = u32StartIndex; u32Index < std::min(u32EndIndex, u32GetSize()); u32Index++)
   {
      clSDS_ListItems oListItem;
      oListItem.oDescription.szString = oGetItem(u32Index);
      oListItems.push_back(oListItem);
   }
   return oListItems;
}


/**************************************************************************//**
 *
 ******************************************************************************/
std::string clSDS_InfoFeedsList::oGetItem(tU32 u32Index)
{
   if (u32Index < _infoFavoriteFeedsList.size())
   {
      return _infoFavoriteFeedsList[u32Index].getStrChannelName();
   }
   return "";
}


/***********************************************************************//**
 *
 ***************************************************************************/
std::vector<sds2hmi_fi_tcl_HMIElementDescrptionList> clSDS_InfoFeedsList::getHmiListDescription()
{
   std::vector<sds2hmi_fi_tcl_HMIElementDescrptionList> infoFeeedsListDetails;

   for (size_t idx = 0; idx < _infoFavoriteFeedsList.size(); ++idx)
   {
      sds2hmi_fi_tcl_HMIElementDescription hmiElementDescription;
      sds2hmi_fi_tcl_HMIElementDescrptionList hmiElementDescriptionList;

      if (! _infoFavoriteFeedsList[idx].getStrChannelName().empty())
      {
         hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_PLAIN_TEXT;
         hmiElementDescription.DescriptorValue =  _infoFavoriteFeedsList[idx].getStrChannelName().c_str();
         hmiElementDescriptionList.DescriptionList.push_back(hmiElementDescription);
      }
      infoFeeedsListDetails.push_back(hmiElementDescriptionList);
   }
   return infoFeeedsListDetails;
}


/***********************************************************************//**

***************************************************************************/
std::vector<sds2hmi_fi_tcl_HMIElementDescription> clSDS_InfoFeedsList::getHmiElementDescription(unsigned int index)
{
   std::vector<sds2hmi_fi_tcl_HMIElementDescription> hmiElementDescriptionList;
   sds2hmi_fi_tcl_HMIElementDescription hmiElementDescription;

   if ((index > 0) && ((index - 1) < _infoFavoriteFeedsList.size()))
   {
      hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_PLAIN_TEXT;
      hmiElementDescription.DescriptorValue = _infoFavoriteFeedsList[index - 1].getStrChannelName().c_str();
      hmiElementDescriptionList.push_back(hmiElementDescription);
   }
   return hmiElementDescriptionList;
}


/**************************************************************************//**
 *
 ******************************************************************************/
tBool clSDS_InfoFeedsList::bSelectElement(tU32 u32SelectedIndex)
{
   if ((u32SelectedIndex > 0) && (u32SelectedIndex <= _infoFavoriteFeedsList.size()))
   {
      _tcuUsbMainProxy->sendSelectFavoriteFeedsStart(*this, _infoFavoriteFeedsList[u32SelectedIndex - 1].getU8FavoriteChannelListID());
      return TRUE;
   }
   return FALSE;
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_InfoFeedsList::onSelectFavoriteFeedsError(
   const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& /*proxy*/,
   const ::boost::shared_ptr< tcu_usb_main_fi::SelectFavoriteFeedsError >& /*error*/)
{
   _infoFavoriteFeedsList.clear();
}


/**************************************************************************//**
 *
*******************************************************************************/
void clSDS_InfoFeedsList::onSelectFavoriteFeedsResult(
   const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& /*proxy*/,
   const ::boost::shared_ptr< SelectFavoriteFeedsResult >& /*result*/)
{
   _infoFavoriteFeedsList.clear();
}
