/**************************************************************************//**
 * \file       clSDS_FuelPriceList.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_FuelPriceList_h
#define clSDS_FuelPriceList_h


#include "application/clSDS_List.h"
#include "application/clSDS_NaviList.h"
#include "application/DistanceDirectionUtility.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "sxm_canadian_fuel_main_fiProxy.h"
#include "sxm_fuel_main_fiProxy.h"
#include "VEHICLE_MAIN_FIProxy.h"

class GuiService;

class clSDS_FuelPriceList :
   public clSDS_List
   , public clSDS_NaviList
   , public asf::core::ServiceAvailableIF
   , public sxm_fuel_main_fi::GetFuelInfoListCallbackIF
   , public sxm_fuel_main_fi::GetFuelStationInfoCallbackIF
   , public sxm_canadian_fuel_main_fi::GetCanadianFuelInfoListCallbackIF
   , public sxm_canadian_fuel_main_fi::GetCanadianFuelStationInfoCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoCallbackIF
   , public org::bosch::cm::navigation::NavigationService::StartGuidanceCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsCallbackIF
   , public org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationCallbackIF
   , public VEHICLE_MAIN_FI::DistanceUnitCallbackIF
{
   public:
      virtual ~clSDS_FuelPriceList();
      clSDS_FuelPriceList(
         boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy > sxmCanadianFuelProxy,
         boost::shared_ptr< sxm_fuel_main_fi::Sxm_fuel_main_fiProxy > sxmFuelProxy,
         boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy,
         boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > naviSDSProxy,
         boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy > vehicleFiProxy,
         GuiService* pGuiService);

      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      unsigned int u32GetSize();

      virtual void onGetFuelInfoListError(
         const ::boost::shared_ptr< sxm_fuel_main_fi::Sxm_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_fuel_main_fi::GetFuelInfoListError >& error) ;
      virtual void onGetFuelInfoListResult(
         const ::boost::shared_ptr< sxm_fuel_main_fi::Sxm_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_fuel_main_fi::GetFuelInfoListResult >& result);

      virtual void onGetFuelStationInfoError(
         const ::boost::shared_ptr<  sxm_fuel_main_fi::Sxm_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr<  sxm_fuel_main_fi::GetFuelStationInfoError >& error);
      virtual void onGetFuelStationInfoResult(
         const ::boost::shared_ptr<  sxm_fuel_main_fi::Sxm_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr<  sxm_fuel_main_fi:: GetFuelStationInfoResult >& result);

      virtual void onGetCanadianFuelInfoListError(
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::GetCanadianFuelInfoListError >& error);

      virtual void onGetCanadianFuelInfoListResult(
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::GetCanadianFuelInfoListResult >& result);

      virtual void onGetCanadianFuelStationInfoError(
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::GetCanadianFuelStationInfoError >& error);

      virtual void onGetCanadianFuelStationInfoResult(
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::GetCanadianFuelStationInfoResult >& result);

      virtual void onPositionStatusInfoError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoError >& error);

      virtual void onPositionStatusInfoUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoUpdate >& update);

      virtual void onStartGuidanceError(
         const ::boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy>& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceError >& error);
      virtual void onStartGuidanceResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceResponse >& response);

      virtual void onSetLocationWithDetailsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsError >& error) ;

      virtual void onSetLocationWithDetailsResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsResponse >& response);

      virtual void onRequestDetailsForSelectedLocationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationError >& error);

      virtual void onRequestDetailsForSelectedLocationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse >& response);

      virtual void onDistanceUnitError(
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::DistanceUnitError >& error);

      virtual void onDistanceUnitStatus(
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::DistanceUnitStatus >& status);

      tBool bSelectElement(tU32 u32SelectedIndex);
      std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);

   private:
      void vStartGuidance();
      void onFuelSortByPriceorDistance(
         sxm_fuel_main_fi_types::T_e8_SortType sortTypeUSA,
         sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType sortTypeCAN);
      void retrieveUSAFuelPriceList(sxm_fuel_main_fi_types::T_e8_SortType sortType);
      void retrieveCanadianFuelPriceList(sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType sortType);

      tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType);
      std::string getFuelPriceValue(tU32 u32Index) const;
      std::string getFuelAge(tU8 u8FuelAge) const;
      std::string getBrandOrFuelStationName(tU32 u32Index) const;
      std::string getDistance(tU32  u32Index) const;
      std::string getLastPriceUpdate(tU32 u32Index) const;
      clSDS_ListItems::tenColorofText enGetFuelAgeColor(tU8 u8FuelAge) const;
      clSDS_ListItems getListItem(tU32 u32Index) const;
      clSDS_ListItems::tenColorofText enGetLastPriceTextColor(tU32 u32Index) const;
      int getDirection(tU32 u32Index) const;
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);

      void setUSAFuelInfoList(const sxm_fuel_main_fi_types::T_FuelInfoList& fuelInfoList);
      void setCanadianFuelInfoList(const sxm_canadian_fuel_main_fi_types::T_CanFuelInfoList& canadianFuelInfoList);
      void setFuelStationLocationDetailsToNavi(unsigned long index);
      void reteriveFuelStationInfoOnSelectElement(unsigned long index);

      enum FuelPriceAge
      {
         TODAY = 0,
         YESTERDAY = 1,
         TWO_DAY = 2,
         THREE_DAY = 3,
         VERY_OLD = 4
      };
      enum enCountryCode
      {
         EN_COUNTRY_CODE_UNKNOWN = 0u,
         EN_COUNTRY_CODE_USA = 1u,
         EN_COUNTRY_CODE_CAN = 2u
      };

      struct stFuelListItems
      {
         std::string szDistanceWithUnits;
         std::string szBrandName;
         std::string szStationName;
         std::string szFuelPriceValue;
         unsigned int fuelLocationID;
         double longitude;
         double latitude;
         unsigned char u8fuelAge;
         int direction;
      };

      struct stFuelStationInfo
      {
         stFuelStationInfo() { }

         std::string szCityName;
         std::string szFuelStationAddress;
         std::string szPhoneNumber;
         std::string szStateName;
         std::string szStationNameBrandName;
      };

      boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy > _sxmCanadianFuelProxy;
      boost::shared_ptr< sxm_fuel_main_fi::Sxm_fuel_main_fiProxy > _sxmFuelProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _naviProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _naviSDSProxy;
      boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy > _vehicleFiProxy;
      GuiService* _pGuiService;

      double _startvehicleheading;
      unsigned char _vehicleEngineType;
      unsigned long _selectElementIndex;
      DistanceDirectionUtility::enDistanceUnitType _vehicleDistanceUnits;
      enCountryCode _enCountryCode;
      std::vector<stFuelListItems> _fuelListItems;
      stFuelStationInfo _fuelStationInfo;
      org::bosch::cm::navigation::NavigationService:: PositionWGS84 _naviGeoPosition;
};


#endif
