/**************************************************************************//**
 * \file       clSDS_DTMFHandler.h
 *
 * clSDS_DTMFHandler (AIF)
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_DTMFHandler_h
#define clSDS_DTMFHandler_h


#include "clSDS_PhoneStatusObserver.h"
#include "clSDS_ActiveScreenObserver.h"
#include "clSDS_SessionControl.h"


class clSDS_DTMFHandler
   : public clSDS_PhoneStatusObserver
   , public clSDS_ActiveScreenObserver
{
   public:
      clSDS_DTMFHandler(clSDS_SessionControl* poSessionControl);
      virtual ~clSDS_DTMFHandler();
      virtual void callStatusChanged(most_Tel_fi_types::T_e8_TelCallStatus firstCallstatus,
                                     most_Tel_fi_types::T_e8_TelCallStatus secondCallstatus);
      virtual void viewIdChanged(const std::string& viewId);

   private:
      clSDS_SessionControl* _pSessionControl;
      std::string _viewId;
};


#endif
