/**************************************************************************//**
 * \file       VariantLayoutMap.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef VariantLayoutMap_h
#define VariantLayoutMap_h


#include <string>
#include <map>


class VariantLayoutMap
{
   public:
      VariantLayoutMap();
      virtual ~VariantLayoutMap();
      unsigned int getItemsPerPage(std::string layoutName) const;
   private:
      std::map<std::string, int> _nissan;
      std::map<std::string, int> _daimler;
      std::map<std::string, int> _renaultPotrait;
      std::map<std::string, int> _renaultLandscape;
      std::map<std::string, int> _variantMap;
      std::map<std::string, int> _nissanA2S1;

      void readVariantandDisplayOrientationInfo();
};


#endif
