/**************************************************************************//**
 * \file       VariantLayoutMap.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "application/VariantLayoutMap.h"
#include "application/clSDS_KDSConfiguration.h"
#include "application/clSDS_ConfigurationFlags.h"
#include "view_db/Sds_ViewDB.h"

VariantLayoutMap::VariantLayoutMap()
{
   _daimler["CV_PHO_T1"]    = 1 ;
   _daimler["CV_NAV_T1"]    = 1 ;
   _daimler["CV_AUD_T1"]    = 1 ;
   _daimler["CV_NAV_CONF"]  = 1 ;
   _daimler["CV_AUD_CONF"]  = 1 ;
   _daimler["CV_NAV_T2"]    = 2 ;
   _daimler["CV_NAV_T4"]    = 4 ;
   _daimler["CV_PHO"]       = 4 ;
   _daimler["CV_NAV_T5"]    = 5 ;
   _daimler["CV_S_PHO"] = 6 ;
   _daimler["CV_S_NAV"] = 6 ;
   _daimler["CV_S_AUD"] = 6 ;
   _daimler["CV_GLO"]   = 10;
   _daimler["CV_E_PHO"] = 8 ;
   _daimler["CV_AUD"]   = 8 ;
   _daimler["CV_TUNER"] = 3 ;

   _nissan["A"] = 4;
   _nissan["B"] = 4;
   _nissan["E"] = 5;
   _nissan["I"] = 5;
   _nissan["L"] = 5;
   _nissan["M"] = 5 ;
   _nissan["N"] = 10 ;
   _nissan["O"] = 5 ;
   _nissan["Q"] = 5;
   _nissan["R"] = 5 ;
   _nissan["S"] = 5 ;
   _nissan["T"] = 5 ;

   _renaultPotrait["B"] = 4;
   _renaultPotrait["L"] = 8;
   _renaultPotrait["L2"] = 8;
   _renaultPotrait["L3"] = 8;
   _renaultPotrait["N"] = 8;
   _renaultPotrait["M"] = 4;
   _renaultPotrait["R2"] = 3;
   _renaultPotrait["T"] = 4;
   _renaultPotrait["TileList"] = 9;

   _renaultLandscape["B"] = 4;
   _renaultLandscape["L"] = 5;
   _renaultLandscape["L2"] = 5;
   _renaultLandscape["L3"] = 5;
   _renaultLandscape["N"] = 5;
   _renaultLandscape["M"] = 5;
   _renaultLandscape["R2"] = 3;
   _renaultLandscape["T"] = 5;
   _renaultLandscape["TileList"] = 8;

   _nissanA2S1["A"] = 4;
   _nissanA2S1["B"] = 3;
   _nissanA2S1["E"] = 6;
   _nissanA2S1["I"] = 6;
   _nissanA2S1["L"] = 6;
   _nissanA2S1["M"] = 6;
   _nissanA2S1["N"] = 12;
   _nissanA2S1["O"] = 6;
   _nissanA2S1["Q"] = 6;
   _nissanA2S1["R"] = 6;
   _nissanA2S1["S"] = 6;
   _nissanA2S1["T"] = 6;

   readVariantandDisplayOrientationInfo();
}


VariantLayoutMap::~VariantLayoutMap()
{
}


void VariantLayoutMap::readVariantandDisplayOrientationInfo()
{
   unsigned int variantValue = 0;

   variantValue = clSDS_KDSConfiguration::getVariantType();

   switch (variantValue)
   {
      case clSDS_KDSConfiguration::TYPE_NISSAN:
      {
         if (clSDS_ConfigurationFlags::isA2S1())
         {
            _variantMap = _nissanA2S1;
         }
         else
         {
            _variantMap = _nissan;
         }
      }
      break;
      case clSDS_KDSConfiguration::TYPE_INFINITI:
      {
         _variantMap = _nissan;
      }
      break;
      case clSDS_KDSConfiguration::TYPE_RENAULT:
      {
         if (clSDS_KDSConfiguration::getDisplayOrientation() == clSDS_KDSConfiguration::LANDSCAPE)
         {
            _variantMap = _renaultLandscape;
         }
         else
         {
            _variantMap = _renaultPotrait;
         }
      }
      break;
      case clSDS_KDSConfiguration::TYPE_DAIMLER:
      {
         _variantMap = _daimler;
      }
      break;
      default:
         break;
   }
}


unsigned int VariantLayoutMap::getItemsPerPage(std::string layoutName) const
{
   std::map <std::string , int>::const_iterator it;
   unsigned int numPages = 1;
   for (it = _variantMap.begin(); it != _variantMap.end(); it++)
   {
      if (it->first == layoutName)
      {
         numPages = it->second;
         return numPages;
      }
   }
   return numPages;
}
