/**************************************************************************//**
 * \file       SystemVoiceSettings.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "CommonSettingsObserver.h"

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_02_if.h"
#include "dp_tclfc_sds_adapter_SpeechSettings.h"
#endif
class SettingsService;

class SystemVoiceSettings
   : public CommonSettingsObserver
{
   public :
      SystemVoiceSettings();
      SystemVoiceSettings(SettingsService*);
      void voicePreferenceChanged();
      void updateBeepOnlyMode(bool beepOnlyModeStatus);
      void promptModeChanged(bool promptMode);
      void updateNBestMatchAudio(bool audioNBest);
      void updateNBestMatchPhoneBook(bool phoneNBest);
      void speechRateChanged(unsigned int speechRate);
      void updateVoiceBargeIn(bool voiceBargeInStatus);
      void getUserProfileData();

   private :
      SettingsService* _pSettingsService;
      dp_tclfc_sds_adapter_SpeechSettingsVoicePreference _dpVoicePreference;
      dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode _dpBeepOnlyMode;
      dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio _dpNBestMatchAudio;
      dp_tclfc_sds_adapter_SpeechSettingsPromptSetting _dpPromptSetting;
      dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook _dpNBestMatchPhoneBook;
      dp_tclfc_sds_adapter_SpeechSettingsSpeechRate _dpSpeechRate;
      dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn _dpVoiceBargeIn;
};
