/**************************************************************************//**
 * \file       SystemVoiceSettings.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/


#include "SystemVoiceSettings.h"
#include "SettingsService.h"

SystemVoiceSettings::SystemVoiceSettings(SettingsService* settingsService)
   : _pSettingsService(settingsService)
{
   _pSettingsService->setBeepOnlyMode(_dpBeepOnlyMode.tGetData());
   _pSettingsService->setShortPrompt(_dpPromptSetting.tGetData());
   _pSettingsService->setBestMatchAudio(_dpNBestMatchAudio.tGetData());
   _pSettingsService->setBestMatchPhoneBook(_dpNBestMatchPhoneBook.tGetData());
   _pSettingsService->setSpeechRate(_dpSpeechRate.tGetData());
   _pSettingsService->setVoiceBargeIn(_dpVoiceBargeIn.tGetData());

   sds_gui_fi::SettingsService::ActiveSpeakerGender gender;
   gender = static_cast<sds_gui_fi::SettingsService::ActiveSpeakerGender>(_dpVoicePreference.tGetData());
   _pSettingsService->setVoicePreference(gender);

   _pSettingsService->addCommonSettingsObserver(this);
}


void SystemVoiceSettings::voicePreferenceChanged()
{
   sds_gui_fi::SettingsService::ActiveSpeakerGender gender;
   gender = _pSettingsService->getVoicePreference();

   _dpVoicePreference.vSetData(static_cast<int>(gender));
}


void SystemVoiceSettings::getUserProfileData()
{
   _pSettingsService->setBeepOnlyMode(_dpBeepOnlyMode.tGetData());
   _pSettingsService->setShortPrompt(_dpPromptSetting.tGetData());
   _pSettingsService->setBestMatchAudio(_dpNBestMatchAudio.tGetData());
   _pSettingsService->setBestMatchPhoneBook(_dpNBestMatchPhoneBook.tGetData());
   _pSettingsService->setSpeechRate(_dpSpeechRate.tGetData());
   _pSettingsService->setVoiceBargeIn(_dpVoiceBargeIn.tGetData());

   sds_gui_fi::SettingsService::ActiveSpeakerGender gender;
   gender = static_cast<sds_gui_fi::SettingsService::ActiveSpeakerGender>(_dpVoicePreference.tGetData());
   _pSettingsService->setVoicePreference(gender);
}


void SystemVoiceSettings::updateBeepOnlyMode(bool beepOnlyModeStatus)
{
   _dpBeepOnlyMode.vSetData(beepOnlyModeStatus);
}


void SystemVoiceSettings::updateNBestMatchAudio(bool audioNBest)
{
   _dpNBestMatchAudio.vSetData(audioNBest);
}


void SystemVoiceSettings::promptModeChanged(bool promptMode)
{
   _dpPromptSetting.vSetData(promptMode);
}


void SystemVoiceSettings::speechRateChanged(unsigned int speechRate)
{
   _dpSpeechRate.vSetData(speechRate);
}


void SystemVoiceSettings::updateNBestMatchPhoneBook(bool phoneNBest)
{
   _dpNBestMatchPhoneBook.vSetData(phoneNBest);
}


void SystemVoiceSettings::updateVoiceBargeIn(bool voiceBargeInStatus)
{
   _dpVoiceBargeIn.vSetData(voiceBargeInStatus);
}
