/**************************************************************************//**
 * \file       StringUtils.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/StringUtils.h"
#include <stdio.h>


StringUtils::StringUtils()
{
}


StringUtils::~StringUtils()
{
}


std::string StringUtils::toString(unsigned int number)
{
   char acBuffer[40];
   sprintf(acBuffer, "%u", number);
   return std::string(acBuffer);
}


std::string& StringUtils::trim(std::string& str)
{
   if (!str.empty())
   {
      size_t lastPos = str.size() - 1;
      size_t iFirst = 0;
      size_t iLast = lastPos;
      for (; iFirst <= lastPos; ++iFirst)
      {
         if (!std::isspace(str[iFirst]))
         {
            break;
         }
      }

      for (; iLast > iFirst; --iLast)
      {
         if (!std::isspace(str[iLast]))
         {
            break;
         }
      }

      if (iFirst != 0 || iLast != lastPos)
      {
         str = str.substr(iFirst, iLast  + 1 - iFirst);
      }
   }

   return str;
}


std::vector<std::string>StringUtils::split(std::string& stringToSplit, std::string& delimiter)
{
   std::string strTemp = stringToSplit;
   std::vector <std::string> stringList;
   size_t pos;

   pos = strTemp.find(delimiter);
   if (std::string::npos != pos)
   {
      stringList.push_back(strTemp.substr(0, pos));
      strTemp = strTemp.substr(pos + delimiter.size(), strTemp.size());
   }
   stringList.push_back(strTemp);
   return stringList;
}


std::string StringUtils::toISOString(size_t isoCode)
{
   std::string s;
   for (size_t i = 0; i < 3; ++i)
   {
      size_t blockSize = 5 * (2 - i);
      char c = '@' + ((isoCode >> blockSize) & 0x1F);
      s += c;
   }
   return s;
}
