/**************************************************************************//**
 * \file       StateNameRequestor.h
 *
 * StateNameRequestor (AIF)
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef StateNameRequestor_h
#define StateNameRequestor_h

#include "asf/core/Proxy.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"

class StateNameObserver;

class StateNameRequestor
   : public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::SdsCheckAddressCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SdsGetRefinementListCallbackIF

{
   public:
      virtual ~StateNameRequestor();
      StateNameRequestor(
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy);

      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      // callbacks by SdsCheckAddressCallbackIF
      virtual void onSdsCheckAddressError(
         const ::boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy>& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsCheckAddressError >& error);
      virtual void onSdsCheckAddressResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsCheckAddressResponse >& sdsCheckAddressResponse);

      // SdsAddressWithOptionsCallbackIF
      virtual void onSdsAddressWithOptionsUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsUpdate >& update);
      virtual void onSdsAddressWithOptionsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsError >& error);

      // callbacks by SdsGetRefinementListCallbackIF
      virtual void onSdsGetRefinementListError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsGetRefinementListError >& error);
      virtual void onSdsGetRefinementListResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsGetRefinementListResponse >& response);

      void getAllStatesforCountry(std::string countryName);
      void addStateObserver(StateNameObserver* pObserver);
      std::string getCountryForGivenStateName(std::string stateName);
      void clearStateList();

   private:
      struct StateDetails
      {
         std::string countryName;
         std::string stateName;
      };

      void notifyStateObservers();
      void handleSdsCheckAddressWithState();
      void requestStateNames();

      boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> _navigationProxy;
      std::vector< StateDetails > _availableStateList;
      std::string _currentCountryName;
      std::vector<StateNameObserver*> _stateObservers;
};


#endif
