/**************************************************************************//**
 * \file       SettingsService.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef SettingsService_h
#define SettingsService_h

#include "sds_gui_fi/SettingsServiceStub.h"
#include "external/sds2hmi_fi.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
class CommonSettingsObserver;

class SettingsService  : public sds_gui_fi::SettingsService::SettingsServiceStub
{
   public:
      SettingsService();
      virtual ~SettingsService();

      virtual void onBeepOnlyModeSet(const ::boost::shared_ptr< sds_gui_fi::SettingsService::BeepOnlyModeSet >& payload);
      virtual void onShortPromptSet(const ::boost::shared_ptr< sds_gui_fi::SettingsService::ShortPromptSet >& payload);
      virtual void onBestMatchAudioSet(const ::boost::shared_ptr< sds_gui_fi::SettingsService::BestMatchAudioSet >& payload);
      virtual void onBestMatchPhoneBookSet(const ::boost::shared_ptr< sds_gui_fi::SettingsService::BestMatchPhoneBookSet >& payload);
      virtual void onVoicePreferenceSet(const ::boost::shared_ptr< sds_gui_fi::SettingsService::VoicePreferenceSet >& payload);
      virtual void onSpeechRateSet(const ::boost::shared_ptr< sds_gui_fi::SettingsService::SpeechRateSet >& payload);
      virtual void onVoiceBargeInSet(const ::boost::shared_ptr< sds_gui_fi::SettingsService::VoiceBargeInSet >& payload);

      void addCommonSettingsObserver(CommonSettingsObserver* pObserver);
      void updateAvailableSpeakers(const std::vector<sds2hmi_fi_tcl_LanguageAndSpeaker>& availableSpeakers);

   private:
      void notifyVoicePreferenceChanged();
      void notifyShortPromptChanged(bool);
      void notifyBeepOnlyModeChanged(bool);
      void notifyBestMatchAudioChanged(bool);
      void notifyBestMatchPhoneBookChanged(bool);
      void notifySpeechRateChanged(unsigned int);
      void notifyVoiceBargeInChanged(bool);

      std::vector<CommonSettingsObserver*> _observers;
};


#endif
