/**************************************************************************//**
 * \file       RestoreHMIList.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef RestoreHMIList_h
#define RestoreHMIList_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


class RestoreHMIListObserver;


class RestoreHMIList
{
   public:
      RestoreHMIList();
      virtual ~RestoreHMIList();
      virtual void vRestoreHMIListData() = 0;
      virtual bool getResultType() = 0;
      void setCurrentHMIListObserver(RestoreHMIListObserver* pRestoreHMIListObserver);
      void notifyRestoreHMIListObserver();

   private:
      RestoreHMIListObserver* _pHMIListObserver;
};


#endif
