/**************************************************************************//**
 * \file       RestoreHMIList.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "RestoreHMIList.h"
#include "application/RestoreHMIListObserver.h"

/**************************************************************************//**
* Destructor
******************************************************************************/

RestoreHMIList::~RestoreHMIList()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
RestoreHMIList::RestoreHMIList(): _pHMIListObserver(NULL)
{
}


/**************************************************************************//**
*
******************************************************************************/
void RestoreHMIList::setCurrentHMIListObserver(RestoreHMIListObserver* pRestoreHMIListObserver)
{
   _pHMIListObserver = pRestoreHMIListObserver;
}


/**************************************************************************//**
*
******************************************************************************/
void RestoreHMIList::notifyRestoreHMIListObserver()
{
   if (_pHMIListObserver != NULL)
   {
      _pHMIListObserver->hmiListRestored(this);
   }
}
