/**************************************************************************//**
 * \file       QuickChargingStation.h
 *
 * QuickChargingStation (AIF)
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef QuickChargingStation_h
#define QuickChargingStation_h


#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/clSDS_List.h"
#include "application/RestoreHMIList.h"


class ChargingStationListObserver;


class QuickChargingStation
   : public clSDS_List
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::DestinationInformationCallbackIF
   , public org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsCallbackIF
   , public RestoreHMIList
   , public org::bosch::cm::navigation::NavigationService::UndoSetLocationWithFixedPOICategoryInputCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SetLocationWithFixedPOICategoryInputCallbackIF
{
   public:
      QuickChargingStation(::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy);
      virtual ~QuickChargingStation();

      virtual void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onDestinationInformationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::DestinationInformationError >& error);

      virtual void onDestinationInformationUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::DestinationInformationUpdate >& update);

      virtual void onRequestFixedPOICategorySearchResultsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsError >& error);

      virtual void onRequestFixedPOICategorySearchResultsResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsResponse >& response);

      virtual void onUndoSetLocationWithFixedPOICategoryInputError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::UndoSetLocationWithFixedPOICategoryInputError >& error);

      virtual void onUndoSetLocationWithFixedPOICategoryInputResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::UndoSetLocationWithFixedPOICategoryInputResponse >& response);

      virtual void onSetLocationWithFixedPOICategoryInputError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputError >& error);

      virtual void onSetLocationWithFixedPOICategoryInputResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputResponse >& response);

      bool getChargingStationListRequestStatus();
      void sendChargingStationListRequest(tU8 ambiguousValue);
      void setChargingStationListRequestStatus(bool chargingStationSelected);
      void registerChargingStationListObserver(ChargingStationListObserver* chargingStationListObserver);

   private:

      enum enHeadingType
      {
         EN_HEADING_INDEX_UNKNOWN         = -1,
         EN_HEADING_INDEX_NORTH           = 0,
         EN_HEADING_INDEX_NORTH_EAST      = 1,
         EN_HEADING_INDEX_EAST            = 2,
         EN_HEADING_INDEX_SOUTH_EAST      = 3,
         EN_HEADING_INDEX_SOUTH           = 4,
         EN_HEADING_INDEX_SOUTH_WEST      = 5,
         EN_HEADING_INDEX_WEST            = 6,
         EN_HEADING_INDEX_NORTH_WEST      = 7,
      };

      virtual tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType);
      virtual tU32 u32GetSize();
      virtual std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      virtual tBool bSelectElement(tU32 u32SelectedIndex);
      virtual std::vector<sds2hmi_fi_tcl_HMIElementDescrptionList> getHmiListDescription();
      std::vector<sds2hmi_fi_tcl_HMIElementDescription>  getHmiElementDescription(unsigned int);
      std::vector<ChargingStationListObserver*> _chargingStationObserverlist;

      bool getResultType();
      std::string oGetItem(tU32 u32Index);
      tU32 getRefinementID(tU32 absoluteValue);
      clSDS_ListItems oGetListItem(tU32 u32Index);
      std::string oGetDisatance(tU32 u32Index);
      void vRestoreHMIListData();
      signed char oGetDirectionFromMapping(tU32 u32Index)const;
      void notifyChargingStationlistObserver();

      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _naviProxy;

      std::vector<org::bosch::cm::navigation::NavigationService::AddressListElement > _addressList;
      tU8 _destinationIndex;
      bool _isChargingStationListRequested;
      bool _restoreHMIListResponse;
};


#endif
