/**************************************************************************//**
 * \file       PhoneUtils.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef PhoneUtils_h
#define PhoneUtils_h

#include "MOST_PhonBk_FIProxy.h"
#include "external/sds2hmi_fi.h"

class PhoneUtils
{
   public:
      static most_PhonBk_fi_types_Extended::T_e8_PhonBkNumberType maptoPhoneBookType(const sds2hmi_fi_tcl_e8_PHN_NumberType::tenType type);
      static sds2hmi_fi_tcl_e8_PHN_NumberType::tenType mapToSds2hmiType(most_PhonBk_fi_types_Extended::T_e8_PhonBkNumberType type);
      static sds2hmi_fi_tcl_e8_PHN_NumberType::tenType getPhoneNumberType(
         const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& contactDetailsExtd);
      static std::string getPhoneNumber(const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& contactDetailsExtd);
};


#endif
