/**************************************************************************//**
 * \file       PhoneUtils.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/PhoneUtils.h"

using namespace most_PhonBk_fi_types_Extended;

/**************************************************************************//**
 *
 ******************************************************************************/
T_e8_PhonBkNumberType PhoneUtils::maptoPhoneBookType(sds2hmi_fi_tcl_e8_PHN_NumberType::tenType type)
{
   T_e8_PhonBkNumberType phoneNumberType = most_PhonBk_fi_types_Extended::T_e8_PhonBkNumberType__NONE;
   switch (type)
   {
      case sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_MOBILE1:
         phoneNumberType = T_e8_PhonBkNumberType__CELL;
         break;
      case sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_HOME1:
         phoneNumberType = T_e8_PhonBkNumberType__HOME;
         break;
      case sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_OFFICE1:
         phoneNumberType = T_e8_PhonBkNumberType__WORK;
         break;
      case sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_OTHER:
         phoneNumberType = T_e8_PhonBkNumberType__OTHER;
         break;
      default:
         phoneNumberType = T_e8_PhonBkNumberType__NONE;
         break;
   }
   return phoneNumberType;
}


/**************************************************************************//**
 *
 ******************************************************************************/
sds2hmi_fi_tcl_e8_PHN_NumberType::tenType PhoneUtils::getPhoneNumberType(const T_PhonBkContactDetailsExtended& contactDetailsExtd)
{
   sds2hmi_fi_tcl_e8_PHN_NumberType::tenType phoneNumberType =  sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_UNKNOWN;

   if (contactDetailsExtd.getOPhoneNumber1().getE8Type() == T_e8_PhonBkNumberType__CELL)
   {
      phoneNumberType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_MOBILE1;
   }
   else if (contactDetailsExtd.getOPhoneNumber2().getE8Type() == T_e8_PhonBkNumberType__CELL)
   {
      phoneNumberType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_MOBILE2;
   }
   else if (contactDetailsExtd.getOPhoneNumber1().getE8Type() == T_e8_PhonBkNumberType__HOME)
   {
      phoneNumberType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_HOME1;
   }
   else if (contactDetailsExtd.getOPhoneNumber2().getE8Type() == T_e8_PhonBkNumberType__HOME)
   {
      phoneNumberType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_HOME2;
   }
   else if (contactDetailsExtd.getOPhoneNumber1().getE8Type() == T_e8_PhonBkNumberType__WORK)
   {
      phoneNumberType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_OFFICE1;
   }
   else if (contactDetailsExtd.getOPhoneNumber2().getE8Type() == T_e8_PhonBkNumberType__WORK)
   {
      phoneNumberType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_OFFICE2;
   }
   else if (contactDetailsExtd.getOPhoneNumber1().getE8Type() == T_e8_PhonBkNumberType__OTHER ||
            contactDetailsExtd.getOPhoneNumber2().getE8Type() == T_e8_PhonBkNumberType__OTHER)
   {
      phoneNumberType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_OTHER;
   }
   else if (contactDetailsExtd.getOPhoneNumber1().getE8Type() == T_e8_PhonBkNumberType__PREFERRED ||
            contactDetailsExtd.getOPhoneNumber2().getE8Type() == T_e8_PhonBkNumberType__PREFERRED)
   {
      phoneNumberType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_UNKNOWN;
   }
   else
   {
      phoneNumberType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_UNKNOWN;
   }
   return phoneNumberType;
}


/**************************************************************************//**
 *
 ******************************************************************************/
std::string PhoneUtils::getPhoneNumber(const T_PhonBkContactDetailsExtended& contactDetailsExtd)
{
   std::string phoneNumber = "";
   if (!contactDetailsExtd.getOPhoneNumber1().getSNumber().empty())
   {
      phoneNumber = contactDetailsExtd.getOPhoneNumber1().getSNumber();
   }
   else if (!contactDetailsExtd.getOPhoneNumber2().getSNumber().empty())
   {
      phoneNumber = contactDetailsExtd.getOPhoneNumber2().getSNumber();
   }
   else if (!contactDetailsExtd.getOPhoneNumber3().getSNumber().empty())
   {
      phoneNumber = contactDetailsExtd.getOPhoneNumber3().getSNumber();
   }
   else if (!contactDetailsExtd.getOPhoneNumber4().getSNumber().empty())
   {
      phoneNumber = contactDetailsExtd.getOPhoneNumber4().getSNumber();
   }
   else if (!contactDetailsExtd.getOPhoneNumber5().getSNumber().empty())
   {
      phoneNumber = contactDetailsExtd.getOPhoneNumber5().getSNumber();
   }
   else if (!contactDetailsExtd.getOPhoneNumber6().getSNumber().empty())
   {
      phoneNumber = contactDetailsExtd.getOPhoneNumber6().getSNumber();
   }
   else if (!contactDetailsExtd.getOPhoneNumber7().getSNumber().empty())
   {
      phoneNumber = contactDetailsExtd.getOPhoneNumber7().getSNumber();
   }
   else if (!contactDetailsExtd.getOPhoneNumber8().getSNumber().empty())
   {
      phoneNumber = contactDetailsExtd.getOPhoneNumber8().getSNumber();
   }
   return phoneNumber;
}


/**************************************************************************//**
 *
 ******************************************************************************/
sds2hmi_fi_tcl_e8_PHN_NumberType::tenType PhoneUtils::mapToSds2hmiType(T_e8_PhonBkNumberType type)
{
   sds2hmi_fi_tcl_e8_PHN_NumberType::tenType sds2hmiType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_UNKNOWN;
   switch (type)
   {
      case T_e8_PhonBkNumberType__CELL:
         sds2hmiType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_MOBILE1;
         break;
      case T_e8_PhonBkNumberType__HOME:
         sds2hmiType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_HOME1;
         break;
      case T_e8_PhonBkNumberType__WORK:
         sds2hmiType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_OFFICE1;
         break;
      case T_e8_PhonBkNumberType__OTHER:
         sds2hmiType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_OTHER;
         break;
      case T_e8_PhonBkNumberType__PREFERRED:
         sds2hmiType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_MAIN;
         break;
      default:
         //T_e8_PhonBkNumberType__PREFERRED
         //T_e8_PhonBkNumberType__NONE
         sds2hmiType = sds2hmi_fi_tcl_e8_PHN_NumberType::FI_EN_UNKNOWN;
         break;
   }
   return sds2hmiType;
}
