/**************************************************************************//**
 * \file       NdsPhonemeRequestor.h
 *
 * NdsPhonemeRequestor (AIF)
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef NdsPhonemeRequestor_h
#define NdsPhonemeRequestor_h


#include "external/sds2hmi_fi.h"
#include "asf/core/Proxy.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include <vector>
#include <string>


class NdsPhonemeObserver;


class NdsPhonemeRequestor
   : public org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsCallbackIF
{
   public:
      virtual ~NdsPhonemeRequestor();
      NdsPhonemeRequestor(
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > naviProxy);

      // callbacks by GetPhonemesForNDSIdsCallbackIF
      virtual void onGetPhonemesForNDSIdsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsError >& error);
      virtual void onGetPhonemesForNDSIdsResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsResponse >& getNamesForNDSIdsResponse);

      void addNdsPhonemeObserver(NdsPhonemeObserver* pObserver);
      void getNdsFeautreTypeForPhoneme(
         std::vector<sds2hmi_fi_tcl_NDSID> ndsIdPhoneme,
         std::vector<sds2hmi_fi_tcl_NDSLanguageID> ndsLanguageId);
      void getNdsPhonemeObjectList(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& phonemeObjectList);
      void getNdsPhonemePOINameList(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& phonemePOINameList);
      void getNdsPhonemePOICategoryList(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& phonemePOICategoryList);
      void getNdsPhonemePOIAttributeList(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& phonemePOIAttributeList);
      void clearAllPhonemeListData();

   private:

      void getNdsIdBasedOnFeatureType(
         sds2hmi_fi_tcl_NDSID ndsIdObject,
         std::vector<sds2hmi_fi_tcl_NDSID>& ndsObjectIdList);
      void updateSDSRequestedFeatureType();
      void getPhonemeForNdsId();
      void sendNdsIdPhonemeRequest(
         std::vector<sds2hmi_fi_tcl_NDSID>& objectIdList,
         org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType ndsFeatureType);
      void getLanguageListEntry(std::vector< org::bosch::cm::navigation::NavigationSDSService::LanguageEntry >& languageEntryList);
      void notifyObjectIdPhonemeListObservers();

      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _navigationSDSProxy;

      std::vector<sds2hmi_fi_tcl_NDSID> _sdsPhonemeObjectList;
      std::vector<sds2hmi_fi_tcl_NDSID> _sdsPhonemePOICategoryList;
      std::vector<sds2hmi_fi_tcl_NDSID> _sdsPhonemePOIBrandNameList;
      std::vector<sds2hmi_fi_tcl_NDSID> _sdsPhonemePOINameList;

      std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _ndsPhonemeObject;
      std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _ndsPhonemePOIName;
      std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _ndsPhonemePOICategory;
      std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _ndsPhonemePOIAttribute;

      std::vector<NdsPhonemeObserver*> _ndsPhonemeObservers;

      std::vector<sds2hmi_fi_tcl_NDSLanguageID> _sdsNdsLanguageId;
      sds2hmi_fi_tcl_e8_NDSFeatureType _currentRequestedFeatureType;
      tU32 _featureTypeRequestCounter;
};


#endif
