/**************************************************************************//**
 * \file       NdsCountryStateRequestor.h
 *
 * clSDS_Method_NavDataGetCountryStateList method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef NdsCountryStateRequestor_h
#define NdsCountryStateRequestor_h


#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "asf/core/Proxy.h"
#include "external/sds2hmi_fi.h"
#include "NdsCountryStateObserver.h"


class NdsCountryStateRequestor
   : public org::bosch::cm::navigation::NavigationSDSService::GetIdListOfCountryAndSubCountryCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsCallbackIF
{
   public:
      NdsCountryStateRequestor(::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > pSds2NaviProxy);

      virtual ~NdsCountryStateRequestor();

      virtual void onGetIdListOfCountryAndSubCountryError
      (const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
       const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetIdListOfCountryAndSubCountryError >& error);
      virtual void onGetIdListOfCountryAndSubCountryResponse
      (const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
       const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetIdListOfCountryAndSubCountryResponse >& response);
      virtual void onGetNamesForNDSIdsError
      (const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
       const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsError >& error);

      virtual void onGetNamesForNDSIdsResponse
      (const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
       const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsResponse >& response);

      void getNdsCountryStateIds();
      void addCountryStateObserver(NdsCountryStateObserver* pObserver);
      unsigned long getNdsCountryListSize();
      std::string getNdsStateName(std::string, std::string);
      std::string getNdsCountryName();
      bool _countryStateNameAvailability;
      bool isCountryStateInfoAvailable() const;

   private:
      std::vector< org::bosch::cm::navigation::NavigationSDSService::SubCountryIds > _stateIdList;
      void getNamesForIds(std::vector< org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId > ndsIds);
      void requestStateNames(org::bosch::cm::navigation::NavigationSDSService::SubCountryIds subCountryIds);
      void updateCountrySubCountryPhonemes(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > stateList);
      void setCountryNameForState(unsigned long countryNdsId, std::string languageCode);
      enum enNDSRequestor
      {
         NDSID_UNKNWON,
         NDSID_FOR_COUNTRY,
         NDSID_FOR_STATE
      };
      enNDSRequestor _ndsRequestor;
      struct stateDetails
      {
         unsigned long countryNdsId;
         unsigned long stateNdsId;
         std::string isoLanguageCode;
         std::vector< std::string > stringnames;
      };

      struct CountryDetails
      {
         unsigned long countryNdsId;
         std::string isoLanguageCode;
         std::vector< std::string > stringnames;;
      };

      std::vector < stateDetails > _stateNamesList;
      std::vector < CountryDetails > _countryNamesList;

      unsigned long _requestedsubCountryNdsIdSize;
      unsigned long _requestedCountryNdsId;
      unsigned long _requestedUpdateRegionId;
      std::string _requestedLanguageCode;
      std::string _requestedCountryCode;
      std::string _correctCountryName;
      std::vector<org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _countryNameList;
      std::vector<org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _stateNameList;
      std::vector<NdsCountryStateObserver*> _countryStateObservers;
      std::vector <std::string> _availableCountryStateList;

      void notifyNdsCountryStateObservers();
      std::string stateNameforLanguageSet(unsigned long ndsId, sds2hmi_fi_tcl_SDSLanguageID);
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _sds2NaviProxy;
};


#endif
