/**************************************************************************//**
 * \file       NaviVoiceTagHandler.h
 *
 * This file is part of the SdsAdapter component.
 * This file is part of the SDS HMI application.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef NaviVoiceTagHandler_h
#define NaviVoiceTagHandler_h


#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/clSDS_SDSStatusObserver.h"


#define NAVIUSERWORDSTART 600
class clSDS_SdsControl;
class clSDS_SDSStatus;
class GuiService;

class NaviVoiceTagHandler
   : public clSDS_SDSStatusObserver
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SdsUpdateVoiceTagCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryCallbackIF
   , public org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationCallbackIF

{
   public:
      NaviVoiceTagHandler(
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> pNaviProxy,
         clSDS_SdsControl* pSdsControl,
         clSDS_SDSStatus* pSDSStatus,
         GuiService& guiService);
      virtual ~NaviVoiceTagHandler();

      void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

      void onSdsVoiceTagWithOptionsUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsUpdate >& update);
      void onSdsVoiceTagWithOptionsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsError >& error);

      void onSdsUpdateVoiceTagError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsUpdateVoiceTagError >& error);
      void onSdsUpdateVoiceTagResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsUpdateVoiceTagResponse >& response);

      void onSetLocationWithDestinationMemoryEntryError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryError >& error);
      void onSetLocationWithDestinationMemoryEntryResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryResponse >& response);

      void onRequestDetailsForSelectedLocationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationError >& error);
      void onRequestDetailsForSelectedLocationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse >& response);

      void updateNaviUserWordList(std::vector<tU32> naviUWs);
      std::string getDestinationMemoryName(tU32 userwordID);
      void setVoiceTagMemoryID(tU32);

   private:
      boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> _navigationProxy;
      clSDS_SdsControl* _pSdsControl;
      clSDS_SDSStatus* _pSDSStatus;
      GuiService& _pGuiService;
      std::vector<tU32>  _NaviUserWords;
      org::bosch::cm::navigation::NavigationService::SDSVoiceTagId _voiceTagID;
      std::vector<org::bosch::cm::navigation::NavigationService::SDSVoiceTagId> listofIDs;

      void createNewVoiceTag();
      void handleVoiceTagUpdate();
      uint32 generateUniqueVoiceTagID();
      void handleVoiceTagBasedOnSDSStatus();
      void handleVoiceTagOptions();
      void deleteListofIDs(tU32);
      void vSDSStatusChanged();
};


#endif
