/**************************************************************************//**
 * \file       NaviPOICategoryList.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef NaviPOICategoryList_h
#define NaviPOICategoryList_h


#include "application/clSDS_List.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include <string>
#include <vector>


class NaviPOICategoryList
   : public clSDS_List
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsCallbackIF
{
   public:
      virtual ~NaviPOICategoryList();
      NaviPOICategoryList(::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy);
      virtual void onMenuPoiCategoryShortcutsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsError >& error);
      virtual void onMenuPoiCategoryShortcutsUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsUpdate >& update);
      virtual void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      uint32 getPOICategoryId(std::string categoryName);

   private:
      virtual tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType) {};
      virtual tU32 u32GetSize();
      virtual std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      virtual tBool bSelectElement(tU32 u32SelectedIndex);
      std::string oGetItem(tU32 u32Index);

      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _naviProxy;
      std::vector< org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut > _sdsPOICategory;
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);
      std::string getCommandString(tU32);
      std::vector<sds2hmi_fi_tcl_HMIElementDescrptionList> getHmiListDescription();
      sds2hmi_fi_tcl_NDSID getDestinationIdList(org::bosch::cm::navigation::NavigationService::GlobalNamedObjectId nameObjectId);
};


#endif
