/**************************************************************************//**
 * \file       NaviDetourList.h
 *
 * NaviDetourList  class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef NaviDetourList_h
#define NaviDetourList_h


#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/clSDS_List.h"
#include "Sds2HmiServer/functions/clSDS_Property_NaviStatus.h"


class NaviDetourList
   : public clSDS_List
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::RequestJamAheadListCallbackIF
   , public org::bosch::cm::navigation::NavigationService::JamAheadListCallbackIF
   , public org::bosch::cm::navigation::NavigationService::ReleaseJamAheadListCallbackIF
{
   public:
      NaviDetourList(
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy,
         clSDS_Property_NaviStatus* naviStatus);
      virtual ~NaviDetourList();

      virtual void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onRequestJamAheadListError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestJamAheadListError >& error);
      virtual void onRequestJamAheadListResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestJamAheadListResponse >& response);

      virtual void onJamAheadListError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::JamAheadListError >& error);
      virtual void onJamAheadListUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::JamAheadListUpdate >& update);

      virtual void onReleaseJamAheadListError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::ReleaseJamAheadListError >& error);
      virtual void onReleaseJamAheadListResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::ReleaseJamAheadListResponse >& response);

      unsigned long getIndexForDistance(std::string distance, sds2hmi_fi_tcl_e8_Distance_Unit::tenType unit);

   private:
      tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType);
      virtual tU32 u32GetSize();
      virtual std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      virtual tBool bSelectElement(tU32 u32SelectedIndex);
      virtual std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);
      virtual std::vector<sds2hmi_fi_tcl_HMIElementDescrptionList> getHmiListDescription();
      std::string oGetItem(tU32 u32Index);
      void mapNaviUnittoSDSUnit();

      ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _pNaviProxy;
      clSDS_Property_NaviStatus* _pNaviStatus;

      ::std::vector< org::bosch::cm::navigation::NavigationService::JamAheadListElement > _jamAheadList;
      bool _detourListRequested;
      std::map<org::bosch::cm::navigation::NavigationService::DistanceUnit, sds2hmi_fi_tcl_e8_Distance_Unit::tenType> _distanceUnitMap;
};


#endif
