/**************************************************************************//**
 * \file       NaviAddressFormatter.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef NaviAddressFormatter_h
#define NaviAddressFormatter_h


#include "org/bosch/cm/navigation/NavigationSDSService.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "external/sds2hmi_fi.h"


class NaviAddressFormatter
   : public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationSDSService::RequestAddressFormatForAvailableCountriesCallbackIF
{
   public:
      NaviAddressFormatter(boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > naviSDSProxy);
      virtual ~NaviAddressFormatter();

      virtual void onRequestAddressFormatForAvailableCountriesError(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
            const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::RequestAddressFormatForAvailableCountriesError >& error);

      virtual void onRequestAddressFormatForAvailableCountriesResponse(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
            const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::RequestAddressFormatForAvailableCountriesResponse >& response);

      virtual void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      std::map < std::string, std::vector <std::string> > getAddressFormat();

   private:
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _naviSDSProxy;
      std::map < std::string, std::vector <std::string> > _countryAddressFormat;
      std::map < std::string, sds2hmi_fi_tcl_e16_ISOCountryCode::tenType > _countryCodeAndNameMapping;
};


#endif
