/**************************************************************************//**
 * \file       EarlyStartupPlayer.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef EarlyStartupPlayer_h
#define EarlyStartupPlayer_h

#include <gst/gst.h>
#include "application/SdsAudioSourceObserver.h"
#include "asf/core/Timer.h"
#include  "vehicle_main_fi_typesConst.h"

#define NUMBER_OF_BYTES_FOR_FILE_LOCATION       256

class SdsAudioSource;
class EarlyPromptStatusObserver;

class EarlyStartupPlayer
   : public SdsAudioSourceObserver
   , public asf::core::TimerCallbackIF
{
   public:
      EarlyStartupPlayer(SdsAudioSource& sdsAudioSource);
      virtual ~EarlyStartupPlayer();

      void onAudioSourceStateChanged(arl_tenActivity state);

      void registerObserver(EarlyPromptStatusObserver* observer);

      void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);

      void requestStartPlayback();
      void requestStopPlayback();

   private:

      struct GstData
      {
         GstElement* file_source;
         GstElement* pipeline;
         GstElement* audio_decoder;
         GstElement* audioconvert;
         GstElement* alsasink;
         GstElement* bin_playback;
         GstBus* bus;
         GstMessage* message;
         gchar filelocation[NUMBER_OF_BYTES_FOR_FILE_LOCATION];

         GstData()
            : file_source(NULL)
            , pipeline(NULL)
            , audio_decoder(NULL)
            , audioconvert(NULL)
            , alsasink(NULL)
            , bin_playback(NULL)
            , bus(NULL)
            , message(NULL)
            , filelocation("")
         {
         }
      };

      void startPlayback();
      void stopPlayback();

      void startTimer();
      void notifyPlaybackFinished();
      void notifyPlaybackTerminated();

      bool createPipeline();
      static void onPadAdded(GstElement* src_element, GstPad* src_pad, gpointer data);
      static void onStreamStatus(GstBus* bus, GstMessage* message, gpointer data);
      bool initAudioPlaybackPipeline();
      void startPlaybackPipe();
      bool addBinPlaybackToPipe();
      void removeBinPlaybackFromPipe();
      void deletePipeline();
      bool checkBusCallback();
      std::string getEarlySDSPromptPath(vehicle_main_fi_types::T_e8_Language_Code systemLanguage);
      vehicle_main_fi_types::T_e8_Language_Code getPromptLanguage();

      SdsAudioSource& _sdsAudioSource;
      EarlyPromptStatusObserver* _earlyPromptStatusObserver;
      bool _audioChannelRequested;
      asf::core::Timer _timer;
      GstData _gstreamerData;
};


#endif
