/**************************************************************************//**
 * \file       DistanceDirectionUtility.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef DistanceDirectionUtility_h
#define DistanceDirectionUtility_h


#include <string>


class DistanceDirectionUtility
{
   public:
      enum enHeadingType
      {
         EN_HEADING_INDEX_UNKNOWN         = -1,
         EN_HEADING_INDEX_NORTH           = 0,
         EN_HEADING_INDEX_NORTH_EAST      = 1,
         EN_HEADING_INDEX_EAST            = 2,
         EN_HEADING_INDEX_SOUTH_EAST      = 3,
         EN_HEADING_INDEX_SOUTH           = 4,
         EN_HEADING_INDEX_SOUTH_WEST      = 5,
         EN_HEADING_INDEX_WEST            = 6,
         EN_HEADING_INDEX_NORTH_WEST      = 7
      };

      enum enDistanceUnitType
      {
         EN_DISTANCE_UNKNOWN = 0,
         EN_DISTANCE_MILES,
         EN_DISTANCE_KM
      };
      struct stGeoCoordinates
      {
         double dLatitude;
         double dLongitude;
         double dVehicleHeading;
      };

      DistanceDirectionUtility();
      virtual ~DistanceDirectionUtility();
      static ::std::string vConvertDistanceToString(float flValue);
      static ::std::string getFormattedDistance(float distanceInMiles, enDistanceUnitType enDistanceUnit);
      static int vConvertLatitudeLongitudeToWGS84(int dLatitudeLongitude);
      static double vConvertLatitudeLongitudeTodouble(int dLatitudeLongitude);
      static int vConvertWGS84ToLatLong(int latlongwsg);
      static enHeadingType oGetDirection(
         const stGeoCoordinates& lSxmGeoCoordinates,
         const stGeoCoordinates& lNaviGeoCoodrdinates);

   private:
      static int getFormatDirectionInfo(double dActualAngle);
      static double vCarRelativeDirection(double currentDirection, double carDirection);
      static bool bCheckLocationBoundary(double dLatitude, double dLongitude);
      static double vConvertDegreesToRadians(double angleDegrees);
      static double vConvertRadiansToDegrees(double angleDegrees);
      static double vMakeCircular(double dDegree);
      static unsigned int vRoundUpToInteger(unsigned int numToRound, unsigned int multiple);
      static std::string vAmericanDistanceUnitHandler(float dDistanceInMiles);

      static double vCalculateDistanceWithDirection(
         const stGeoCoordinates& lSxmGeoCoordinates,
         const stGeoCoordinates& lNaviGeoCoodrdinates);
};


#endif
