/**************************************************************************//**
 * \file       DiagnosticsClientHandler.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2022 Robert Bosch GmbH
 *             (C) 2022 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/


#ifndef DIAGNOSTICS_CLIENT_HANDLER_H
#define DIAGNOSTICS_CLIENT_HANDLER_H

#include "Midw_Diagnostics_FIProxy.h"

using namespace Midw_Diagnostics_FI;


class DiagnosticsClientHandler
   : public asf::core::ServiceAvailableIF
   , public Midw_Diagnostics_FI::SetRunTimeSourceDataCallbackIF
{
   public:
      DiagnosticsClientHandler(boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy > diagnosticProxy);
      virtual ~DiagnosticsClientHandler();
      static DiagnosticsClientHandler* getInstance();

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onSetRunTimeSourceDataError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataError >& error);
      void onSetRunTimeSourceDataResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataResult >& result);

      void updateGuidanceRuntimeInfo(uint32_t count);
      void computeGuidanceRuntime(bool guidanceStatus);

   private:

      ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy > _diagnosticProxy;
};


#endif // DIAGNOSTICS_CLIENT_HANDLER_H
