/**************************************************************************//**
 * \file       DiagnosticsClientHandler.cpp
 *
 * SxmDataService class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "DiagnosticsClientHandler.h"

#define OSAL_S_IMPORT_INTERFACE_THREADING
#include "osal_if.h"
#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/DiagnosticsClientHandler.cpp.trc.h"
#endif

static const uint16_t RUNTIME_U16_APP_SDS_RG  = 0x000C;

using namespace ::asf::core;
using namespace Midw_Diagnostics_FI;

DiagnosticsClientHandler::DiagnosticsClientHandler(boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy > diagnosticProxy)
   : _diagnosticProxy(diagnosticProxy)
{
}


DiagnosticsClientHandler::~DiagnosticsClientHandler()
{
}


void DiagnosticsClientHandler::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::onAvailable"));
}


void DiagnosticsClientHandler::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::onUnavailable"));
}


void DiagnosticsClientHandler::onSetRunTimeSourceDataError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataError >& error)
{
   ETG_TRACE_ERR(("DiagnosticsClientHandler::onSetRunTimeSourceDataError()"));
}


void DiagnosticsClientHandler::onSetRunTimeSourceDataResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataResult >& result)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::onSetRunTimeSourceDataResult()"));
}


void DiagnosticsClientHandler::updateGuidanceRuntimeInfo(uint32_t count)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::updateGuidanceRuntimeInfo : %d count", count));
   if (_diagnosticProxy != NULL)
   {
      _diagnosticProxy->sendSetRunTimeSourceDataStart(*this, RUNTIME_U16_APP_SDS_RG, count);
   }
}


void DiagnosticsClientHandler::computeGuidanceRuntime(bool pttTimeStatus)
{
   static uint32_t pttStartTime = 0;
   static uint32_t pttStopTime = 0;
   if (true == pttTimeStatus)
   {
      pttStartTime = OSAL_ClockGetElapsedTime();
      ETG_TRACE_COMP(("DiagnosticsClientHandler::computeGuidanceRuntime(), PTT start time : %d ms", pttStartTime));
   }
   else
   {
      pttStopTime = OSAL_ClockGetElapsedTime();
      ETG_TRACE_COMP(("DiagnosticsClientHandler::computeGuidanceRuntime(), PTT stop time : %d ms", pttStopTime));

      uint32_t duration = (pttStopTime - pttStartTime) / 1000;   // Convert milliseconds to seconds
      ETG_TRACE_COMP(("DiagnosticsClientHandler::computeGuidanceRuntime(), duration : %d ms", duration));

      pttStartTime = pttStopTime = 0;
      if (duration > 0)
      {
         updateGuidanceRuntimeInfo(1);
      }
   }
}
