/**************************************************************************//**
 * \file       CountryNameRequestor.h
 *
 * CountryNameRequestor (AIF)
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef CountryNameRequestor_h
#define CountryNameRequestor_h

#include "application/StateNameObserver.h"
#include "asf/core/Proxy.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/clSDS_SDSStatusObserver.h"

class StateNameRequestor;
class CountryNameObserver;
class clSDS_SDSStatus;


class CountryNameRequestor
   : public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::SdsCheckAddressCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SdsGetRefinementListCallbackIF
   , public StateNameObserver
   , public clSDS_SDSStatusObserver
{
   public:
      virtual ~CountryNameRequestor();
      CountryNameRequestor(
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy
         , StateNameRequestor* pStateNameRequestor
         , clSDS_SDSStatus* pSDSStatus);

      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      // callbacks by SdsCheckAddressCallbackIF
      virtual void onSdsCheckAddressError(
         const ::boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy>& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsCheckAddressError >& error);
      virtual void onSdsCheckAddressResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsCheckAddressResponse >& sdsCheckAddressResponse);

      // SdsAddressWithOptionsCallbackIF
      virtual void onSdsAddressWithOptionsUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsUpdate >& update);
      virtual void onSdsAddressWithOptionsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsError >& error);

      // callbacks by SdsGetRefinementListCallbackIF
      virtual void onSdsGetRefinementListError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsGetRefinementListError >& error);
      virtual void onSdsGetRefinementListResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsGetRefinementListResponse >& response);

      void sendCheckAddressForCountry();
      void statesUpdated();
      void addCountryObserver(CountryNameObserver* pObserver);
      tU32 getCountryListSize();
      std::string getCountryName(std::string stateName);
      void vSDSStatusChanged();

   private:

      void notifyCountryObservers();
      void handleSdsCheckAddressWithCountry();
      void requestCountryNames();
      void getStateName();

      boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> _navigationProxy;
      std::vector <std::string> _availableCountryList;
      StateNameRequestor* _stateNameRequestor;
      tU32 _requestedCountryIndex;
      std::vector<CountryNameObserver*> _countryObservers;
      clSDS_SDSStatus* _pSDSStatus;
};


#endif
