/**************************************************************************//**
 * \file       clSDS_Property_TunerStatus.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Property_TunerStatus_h
#define clSDS_Property_TunerStatus_h


#include "Sds2HmiServer/framework/clServerProperty.h"
#include "application/clSDS_TunerStateObserver.h"
#include "application/clSDS_SDSStatusObserver.h"
#include "application/clSDS_SDSStatus.h"
class clSDS_Property_TunerStatus
   : public clServerProperty,
     public clSDS_TunerStateObserver,
     public clSDS_SDSStatusObserver
{
   public:
      virtual ~clSDS_Property_TunerStatus();
      clSDS_Property_TunerStatus(ahl_tclBaseOneThreadService* pService, clSDS_SDSStatus* pSdsStatus);

   protected:
      virtual tVoid vGet(amt_tclServiceData* pInMsg);
      virtual tVoid vSet(amt_tclServiceData* pInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* pInMsg);
      virtual void vSDSStatusChanged();

   private:
      tVoid vSendStatus();
      tVoid vTunerStatusChanged(sds2hmi_fi_tcl_e8_TUN_Band::tenType devID, sds2hmi_fi_tcl_e8_DeviceStatus::tenType devStatus);

      std::vector<sds2hmi_fi_tcl_DeviceStatus> _deviceList;
      clSDS_SDSStatus* _pSdsStatus;
      clSDS_SDSStatus::enSDSStatus _prevSdsStatus;
};


#endif
