/**************************************************************************//**
 * \file       clSDS_Property_NaviCurrentCountryState.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Property_NaviCurrentCountryState_h
#define clSDS_Property_NaviCurrentCountryState_h


#include "external/sds2hmi_fi.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "Sds2HmiServer/framework/clServerProperty.h"
#include "Sds2HmiServer/functions/clSDS_Method_NavDataRegisterDirectNDSUse.h"
#include "application/NaviGlobalDataForSdsObserver.h"


class clSDS_Property_NaviCurrentCountryState
   : public clServerProperty
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationSDSService::PositionInfoCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoCallbackIF
   , public NaviGlobalDataForSdsObserver
{
   public:
      virtual ~clSDS_Property_NaviCurrentCountryState();
      clSDS_Property_NaviCurrentCountryState(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> naviSDSProxy,
         clSDS_Method_NavDataRegisterDirectNDSUse* pMethodNavDataRegisterDirectNDSUse);

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onPositionInfoError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::PositionInfoError >& error);
      virtual void onPositionInfoUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::PositionInfoUpdate >& update);

      virtual void onPositionStatusInfoError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoError >& error);
      virtual void onPositionStatusInfoUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoUpdate >& update);

      void sendResponse();
      void sendCountryStateStatusUsingTTFis(std::map<std::string, std::string> positionInfo);

   protected:
      virtual void vGet(amt_tclServiceData* pInMsg);
      virtual void vSet(amt_tclServiceData* pInMsg);
      virtual void vUpreg(amt_tclServiceData* pInMsg);

   private:

      void sendCountryStateStatus(
         const org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfo& positionStatus,
         const org::bosch::cm::navigation::NavigationSDSService::PositionInfo& position);
      void validateAndSendPosition(
         const org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfo& positionStatus,
         const org::bosch::cm::navigation::NavigationSDSService::PositionInfo& position);
      void onNaviGlobalDataForSdsResponse();
      static sds2hmi_fi_tcl_e16_ISOCountryCode::tenType convertNaviStringtoISOCountryCode(const std::string& countryCode);

      boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> _naviSDSProxy;
      clSDS_Method_NavDataRegisterDirectNDSUse* _pMethodNavDataRegisterDirectNDSUse;
};


#endif
