/**************************************************************************//**
 * \file       clSDS_Property_InfoServiceStatus.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef clSDS_Property_InfoServiceStatus_h
#define clSDS_Property_InfoServiceStatus_h

#include "application/SxmDataServicesObserver.h"
#include "Sds2HmiServer/framework/clServerProperty.h"


class SxmDataServices;

class clSDS_Property_InfoServiceStatus
   : public clServerProperty
   , public SxmDataServicesObserver
{
   public:
      virtual ~ clSDS_Property_InfoServiceStatus();
      clSDS_Property_InfoServiceStatus(ahl_tclBaseOneThreadService* pService, SxmDataServices* pSxmDataServices);

   protected:
      virtual tVoid vGet(amt_tclServiceData* pInMsg);
      virtual tVoid vSet(amt_tclServiceData* pInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* pInMsg);

   private:
      void vSendStatus();

      void notifyInfoMenuServiceStatus(
         const std::map<sds2hmi_fi_tcl_e8_Info_SXM_Services::tenType, sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::tenType>& infoMenuList);
      std::vector<sds2hmi_fi_tcl_Info_Menu_Srvice_Status> _infoMenuStatusList;
};


#endif
