/**************************************************************************//**
 * \file      clSDS_Property_InfoServiceStatus.cpp
 *
 * Common Action Request property implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Property_InfoServiceStatus.h"
#include "application/SxmDataServices.h"


/**************************************************************************//**
*
******************************************************************************/
clSDS_Property_InfoServiceStatus::~clSDS_Property_InfoServiceStatus()
{
}


/**************************************************************************//**
*
******************************************************************************/
clSDS_Property_InfoServiceStatus::clSDS_Property_InfoServiceStatus(
   ahl_tclBaseOneThreadService* pService,
   SxmDataServices* pSxmDataServices)
   : clServerProperty(SDS2HMI_SDSFI_C_U16_INFOSERVICESTATUS, pService)
{
   if (pSxmDataServices)
   {
      pSxmDataServices->addSxmDataServiceObserver(this);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_InfoServiceStatus::vSet(amt_tclServiceData* /*pInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_InfoServiceStatus::vGet(amt_tclServiceData* /*pInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_InfoServiceStatus::vUpreg(amt_tclServiceData* /*pInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_InfoServiceStatus::vSendStatus()
{
   sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus oMessage;
   oMessage.Info_Menu_StatusList = _infoMenuStatusList;
   vStatus(oMessage);
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_InfoServiceStatus::notifyInfoMenuServiceStatus(
   const std::map < sds2hmi_fi_tcl_e8_Info_SXM_Services::tenType,
   sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::tenType >& infoMenuList)
{
   _infoMenuStatusList.clear();

   std::map < sds2hmi_fi_tcl_e8_Info_SXM_Services::tenType,
       sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::tenType > ::const_iterator iter = infoMenuList.begin();

   while (iter != infoMenuList.end())
   {
      sds2hmi_fi_tcl_Info_Menu_Srvice_Status infoMenuServiceStatus;
      infoMenuServiceStatus.ServiceMenu.enType = (*iter).first;
      infoMenuServiceStatus.Status.enType = (*iter).second;
      _infoMenuStatusList.push_back(infoMenuServiceStatus);
      ++iter;
   }

   vSendStatus();
}
