/**************************************************************************//**
 * \file       clSDS_Property_ConnectedDeviceStatus.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Property_ConnectedDeviceStatus_h
#define clSDS_Property_ConnectedDeviceStatus_h


#include "Sds2HmiServer/framework/clServerProperty.h"
#include "external/sds2hmi_fi.h"

class SdsPhoneService;

class clSDS_Property_ConnectedDeviceStatus
   : public clServerProperty
{
   public:
      virtual ~clSDS_Property_ConnectedDeviceStatus();
      clSDS_Property_ConnectedDeviceStatus(ahl_tclBaseOneThreadService* pService, SdsPhoneService* pSdsPhoneService);

   protected:
      virtual tVoid vGet(amt_tclServiceData* pInMsg);
      virtual tVoid vSet(amt_tclServiceData* pInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* pInMsg);
      void vSendStatus();
      void extractConnectedDevicePhonetizationstatus(const std::vector<sds2hmi_fi_tcl_ConnectedDeviceStatus>& connectedDeviceStatus);
      void sendPhonebookPhonetizationStatus(sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::tenType entype);

      SdsPhoneService* _pSdsPhoneService;
      std::vector<sds2hmi_fi_tcl_ConnectedDeviceStatus> _connectedDeviceStatus;
      tU8 _mediaState;
      std::vector<sds2hmi_fi_tcl_e8_Slot> _e8Slot;
      sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::tenType _phonebookPhonetizationStatus;
};


#endif
