/**************************************************************************//**
 * \file       clSDS_Property_CommonSDSConfiguration_Dyna.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Property_CommonSDSConfiguration_Dyna_h
#define clSDS_Property_CommonSDSConfiguration_Dyna_h


#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/NavigationAvailabilityObserver.h"
#include "Sds2HmiServer/framework/clServerProperty.h"
#include "application/clSDS_QuickDialListObserver.h"
#include "application/clSDS_XMLStringCreation.h"
#include "application/SxmDataServicesObserver.h"
#include "application/VDEAvailabilityObserver.h"
#include "application/TemperatureUnitObserver.h"
#include "application/CommonSettingsObserver.h"

#include "VEHICLE_MAIN_FIProxy.h"
#include "tcu_main_fiProxy.h"


class clSDS_Property_NavDataDataSetInfo;
class clSDS_Property_NaviStatus;
class clSDS_Method_InfoShowMenu;
class clSDS_ConfigurationFlags;
class SettingsService;

class clSDS_Property_CommonSDSConfiguration_Dyna
   : public clServerProperty
   , public asf::core::ServiceAvailableIF
   , public CommonSettingsObserver
   , public tcu_main_fi::ConnectionCallbackIF
   , public org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusCallbackIF
   , public NavigationAvailabilityObserver
   , public VDEAvailabilityObserver
   , public VEHICLE_MAIN_FI::DistanceUnitCallbackIF
   , public clSDS_QuickDialListObserver
   , public TemperatureUnitObserver
{
   public:
      virtual ~clSDS_Property_CommonSDSConfiguration_Dyna();

      clSDS_Property_CommonSDSConfiguration_Dyna(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< tcu_main_fi::Tcu_main_fiProxy > tcuFiProxy,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy,
         SettingsService* settingsService,
         clSDS_ConfigurationFlags* configFlags,
         clSDS_Property_NavDataDataSetInfo* pNavDataRegisterDirectNDSUse,
         clSDS_Property_NaviStatus* pNaviStatus,
         boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy > vehicleProxy);

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      //callbacks for TCU service  Available  from tcu_main_fi
      virtual void onConnectionError(
         const ::boost::shared_ptr< tcu_main_fi::Tcu_main_fiProxy >& proxy,
         const ::boost::shared_ptr< tcu_main_fi::ConnectionError >& error);

      virtual void onConnectionStatus(
         const ::boost::shared_ptr< tcu_main_fi::Tcu_main_fiProxy >& proxy,
         const ::boost::shared_ptr< tcu_main_fi::ConnectionStatus >& status);

      virtual void onTrafficServiceReceptionStatusError(
         const ::boost::shared_ptr< ::org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusError >& error);

      virtual  void onTrafficServiceReceptionStatusUpdate(
         const ::boost::shared_ptr< ::org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusUpdate >& update);

      virtual void onDistanceUnitError(
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::DistanceUnitError >& error);

      virtual void onDistanceUnitStatus(
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< VEHICLE_MAIN_FI::DistanceUnitStatus >& status);

      virtual void updateNBestMatchAudio(bool audioNBest);
      virtual void updateNBestMatchPhoneBook(bool phoneNBest);
      virtual void updateBeepOnlyMode(bool beepOnlyModeStatus);
      virtual void updateVoiceBargeIn(bool voiceBargeInStatus);

      void onInUseRelationshipsChanged(const std::set<std::string>& inUseRelationships);

   protected:
      virtual tVoid vGet(amt_tclServiceData* pInMsg);
      virtual tVoid vSet(amt_tclServiceData* pInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* pInMsg);

   private:
      tVoid vSendStatus();
      void updateTcuAvailability();
      bool isInfAvailable(bool tcuAvailable);
      bool isRelationshipUsed(const std::set<std::string>& inUseRelationships, std::string cateroty);
      void hvacTemperatureUnitUpdated(bool isCelsiusON);

      void onNaviAvailabilityStatus();
      void onVDEAvalabilityStatus();
      SDSConfigData _sdsConfigData;
      boost::shared_ptr< tcu_main_fi::Tcu_main_fiProxy > _tcuFiProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _naviProxy;
      clSDS_ConfigurationFlags* _pconfigFlags;
      boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy > _vehicleProxy;
      bool _tcuConnected;
};


#endif
