/**************************************************************************//**
 * \file       clSDS_Property_Audio_ECNR_EngineParameter.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Property_Audio_ECNR_EngineParameter_h
#define clSDS_Property_Audio_ECNR_EngineParameter_h


#include "Sds2HmiServer/framework/clServerProperty.h"
#include "external/sds2hmi_fi.h"
#include "org/bosch/ecnr/serviceProxy.h"
#include "application/SdsAudioSourceObserver.h"
#include "application/SdsAudioSource.h"
#include "application/EcnrEngineParamObserver.h"


class clSDS_Property_Audio_ECNR_EngineParameter
   : public clServerProperty
   , public org::bosch::ecnr::service::EcnrGetEngineParameterCallbackIF
   , public SdsAudioSourceObserver
{
   public:
      virtual ~clSDS_Property_Audio_ECNR_EngineParameter();
      clSDS_Property_Audio_ECNR_EngineParameter(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy > ecnrProxy,
         SdsAudioSource& sdsAudioSource);

      virtual void onEcnrGetEngineParameterError(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrGetEngineParameterError >& error);

      virtual void onEcnrGetEngineParameterResponse(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrGetEngineParameterResponse>& response);

      virtual void onAudioSourceStateChanged(arl_tenActivity state);

      virtual void addObserver(EcnrEngineParamObserver* observer);

   protected:
      virtual tVoid vGet(amt_tclServiceData* pInMsg);
      virtual tVoid vSet(amt_tclServiceData* pInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* pInMsg);

   private:
      void sendEngineParameterStatus();
      void requestEngineParameter();
      void notifyObservers();

      boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy > _ecnrProxy;
      std::vector< uint8 > _engineParameter;
      std::vector<EcnrEngineParamObserver*> _observers;
      SdsAudioSource& _sdsAudioSource;
};


#endif
