/**************************************************************************//**
 * \file       clSDS_Property_Audio_ECNR_EngineParameter.cpp
 *
 * Audio_ECNR_EngineParameter Property implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Property_Audio_ECNR_EngineParameter.h"
#include "external/sds2hmi_fi.h"
#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Property_Audio_ECNR_EngineParameter.cpp.trc.h"
#endif


using namespace org::bosch::ecnr::service;


#define ECNR_PARAMETER_ID  91


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Property_Audio_ECNR_EngineParameter::~clSDS_Property_Audio_ECNR_EngineParameter()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Property_Audio_ECNR_EngineParameter::clSDS_Property_Audio_ECNR_EngineParameter(
   ahl_tclBaseOneThreadService* pService,
   ::boost::shared_ptr< ServiceProxy > ecnrProxy,
   SdsAudioSource& sdsAudioSource)

   : clServerProperty(SDS2HMI_SDSFI_C_U16_AUDIO_ECNR_ENGINEPARAMETER, pService)
   , _ecnrProxy(ecnrProxy)
   , _sdsAudioSource(sdsAudioSource)
{
   _sdsAudioSource.addObserver(this);
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_Audio_ECNR_EngineParameter::onAudioSourceStateChanged(arl_tenActivity state)
{
   ETG_TRACE_USR4(("clSDS_Property_Audio_ECNR_EngineParameter::onAudioSourceStateChanged state = %d", state));

   if (state == ARL_EN_ISRC_ACT_ON)
   {
      requestEngineParameter();
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_Audio_ECNR_EngineParameter::requestEngineParameter()
{
   if (_ecnrProxy->isAvailable())
   {
      _ecnrProxy->sendEcnrGetEngineParameterRequest(*this, ECNR_PARAMETER_ID);
   }
   else
   {
      _engineParameter.clear();
      notifyObservers();
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_Audio_ECNR_EngineParameter::onEcnrGetEngineParameterError(
   const ::boost::shared_ptr< ServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< EcnrGetEngineParameterError >& /*error*/)
{
   _engineParameter.clear();
   notifyObservers();
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_Audio_ECNR_EngineParameter::onEcnrGetEngineParameterResponse(
   const ::boost::shared_ptr< ServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< EcnrGetEngineParameterResponse >& response)
{
   _engineParameter = response->getData();
   sendEngineParameterStatus();
   notifyObservers();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_Audio_ECNR_EngineParameter::vSet(amt_tclServiceData* /*pInMsg*/)
{
   // read-only property - ignore set and reply current status
   sendEngineParameterStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_Audio_ECNR_EngineParameter::vGet(amt_tclServiceData* /*pInMsg*/)
{
   sendEngineParameterStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_Audio_ECNR_EngineParameter::vUpreg(amt_tclServiceData* /*pInMsg*/)
{
   sendEngineParameterStatus();
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_Audio_ECNR_EngineParameter::sendEngineParameterStatus()
{
   sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus status;
   status.DataSize = _engineParameter.size();
   status.DataList = _engineParameter;
   vStatus(status);
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_Audio_ECNR_EngineParameter::addObserver(EcnrEngineParamObserver* observer)
{
   if (observer != NULL)
   {
      _observers.push_back(observer);
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_Audio_ECNR_EngineParameter::notifyObservers()
{
   std::vector<EcnrEngineParamObserver*>::const_iterator iter;

   for (iter = _observers.begin(); iter != _observers.end(); ++iter)
   {
      if (*iter != NULL)
      {
         (*iter)->onEcnrEngineParameterChanged();
      }
   }
}
