/**************************************************************************//**
 * \file       clSDS_Property_AudioECNR_ASR_ModeStatus.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Property_AudioECNR_ASR_ModeStatus_h
#define clSDS_Property_AudioECNR_ASR_ModeStatus_h


#include "Sds2HmiServer/framework/clServerProperty.h"
#include "external/sds2hmi_fi.h"
#include "org/bosch/ecnr/serviceProxy.h"


class clSDS_Property_AudioECNR_ASR_ModeStatus
   : public clServerProperty
   , public asf::core::ServiceAvailableIF
   , public org::bosch::ecnr::service::EcnrAsrModeCallbackIF
   , public org::bosch::ecnr::service::EcnrAsrModeEnableCallbackIF
{
   public:
      virtual ~clSDS_Property_AudioECNR_ASR_ModeStatus();
      clSDS_Property_AudioECNR_ASR_ModeStatus(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy > ecnrProxy);

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onEcnrAsrModeEnableSignal(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrAsrModeEnableSignal >& signal);
      virtual void onEcnrAsrModeEnableError(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrAsrModeEnableError >& error);

      virtual void onEcnrAsrModeUpdate(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrAsrModeUpdate >& update);
      virtual void onEcnrAsrModeError(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrAsrModeError >& error);

   protected:
      virtual tVoid vGet(amt_tclServiceData* pInMsg);
      virtual tVoid vSet(amt_tclServiceData* pInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* pInMsg);

   private:
      void sendStatus();

      boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy > _ecnrProxy;
      tBool _ecnrAsrEnabled;
      sds2hmi_fi_tcl_e32_SSE_ASR_Mode::tenType _ecnrAsrMode;
};


#endif
