/**************************************************************************//**
 * \file       clSDS_Property_AudioECNR_ASR_ModeStatus.cpp
 *
 * Common Action Request property implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Property_AudioECNR_ASR_ModeStatus.h"


using namespace org::bosch::ecnr::service;


enum ecnrAsrModes
{
   ASRMode_SetTo_Audio                  = -1,
   ASRMode_SetTo_SSEAUDIOONLY           = 1,
   ASRMode_SetTo_SSESPEECHPROB_ATTACHED = 2,
   ASRMode_SetTo_SSESPEECHPROB_LSB      = 3
};


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Property_AudioECNR_ASR_ModeStatus::~clSDS_Property_AudioECNR_ASR_ModeStatus()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Property_AudioECNR_ASR_ModeStatus::clSDS_Property_AudioECNR_ASR_ModeStatus(
   ahl_tclBaseOneThreadService* pService,
   ::boost::shared_ptr< ServiceProxy > ecnrProxy)

   : clServerProperty(SDS2HMI_SDSFI_C_U16_AUDIOECNR_ASR_MODE_STATUS, pService)
   , _ecnrProxy(ecnrProxy)
   , _ecnrAsrEnabled(false)
   , _ecnrAsrMode(sds2hmi_fi_tcl_e32_SSE_ASR_Mode::FI_EN_UNKNOWN)
{
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_AudioECNR_ASR_ModeStatus::onAvailable(
   const boost::shared_ptr<asf::core::Proxy>& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _ecnrProxy)
   {
      _ecnrProxy->sendEcnrAsrModeEnableRegister(*this);
      _ecnrProxy->sendEcnrAsrModeRegister(*this);
      _ecnrProxy->sendEcnrAsrModeGet(*this);
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_AudioECNR_ASR_ModeStatus::onUnavailable(
   const boost::shared_ptr<asf::core::Proxy>& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _ecnrProxy)
   {
      _ecnrProxy->sendEcnrAsrModeEnableDeregisterAll();
      _ecnrProxy->sendEcnrAsrModeDeregisterAll();
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_AudioECNR_ASR_ModeStatus::onEcnrAsrModeEnableSignal(
   const ::boost::shared_ptr< ServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< EcnrAsrModeEnableSignal >& signal)
{
   _ecnrAsrEnabled = (signal->getStatusAsrMode() != 0);
   if (_ecnrProxy->isAvailable())
   {
      _ecnrProxy->sendEcnrAsrModeGet(*this);
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_AudioECNR_ASR_ModeStatus::onEcnrAsrModeEnableError(
   const ::boost::shared_ptr< ServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< EcnrAsrModeEnableError >& /*error*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
static sds2hmi_fi_tcl_e32_SSE_ASR_Mode::tenType getSdsAsrMode(int32 ecnrAsrMode)
{
   switch (ecnrAsrMode)
   {
      case ASRMode_SetTo_Audio:
         return sds2hmi_fi_tcl_e32_SSE_ASR_Mode::FI_EN_UNKNOWN;

      case ASRMode_SetTo_SSEAUDIOONLY:
         return sds2hmi_fi_tcl_e32_SSE_ASR_Mode::FI_EN_SSEAUDIOONLY;

      case ASRMode_SetTo_SSESPEECHPROB_ATTACHED:
         return sds2hmi_fi_tcl_e32_SSE_ASR_Mode::FI_EN_SSESPEECHPROBATTACHED;

      case ASRMode_SetTo_SSESPEECHPROB_LSB:
         return sds2hmi_fi_tcl_e32_SSE_ASR_Mode::FI_EN_SSESPEECHPROBLSB;

      default :
         return sds2hmi_fi_tcl_e32_SSE_ASR_Mode::FI_EN_UNKNOWN;
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_AudioECNR_ASR_ModeStatus::onEcnrAsrModeUpdate(
   const ::boost::shared_ptr< ServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< EcnrAsrModeUpdate >& update)
{
   _ecnrAsrMode = getSdsAsrMode(update->getEcnrAsrMode());
   sendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_AudioECNR_ASR_ModeStatus::onEcnrAsrModeError(
   const ::boost::shared_ptr< ServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< EcnrAsrModeError >& /*error*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_AudioECNR_ASR_ModeStatus::vSet(amt_tclServiceData* /*pInMsg*/)
{
   // read-only property - ignore set and reply current status
   sendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_AudioECNR_ASR_ModeStatus::vGet(amt_tclServiceData* /*pInMsg*/)
{
   sendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_AudioECNR_ASR_ModeStatus::vUpreg(amt_tclServiceData* /*pInMsg*/)
{
   sendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_AudioECNR_ASR_ModeStatus::sendStatus()
{
   sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus oMessage;
   oMessage.ECNR_ASR_Status.Mode_Enable = _ecnrAsrEnabled;
   oMessage.ECNR_ASR_Status.Mode_Status.enType = _ecnrAsrMode;
   vStatus(oMessage);
}
