/**************************************************************************//**
 * \file       clSDS_Method_TunerSelectBandMemBank.cpp
 *
 * clSDS_Method_TunerSelectBandMemBank method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_TunerSelectBandMemBank.h"

#define ETG_ENABLED
#include "trace_interface.h"

#include "SdsAdapter_Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_TunerSelectBandMemBank.cpp.trc.h"
#endif


using namespace sds_gui_fi::SdsGuiService;


/**************************************************************************//**
 * Constructor
 ******************************************************************************/
clSDS_Method_TunerSelectBandMemBank::clSDS_Method_TunerSelectBandMemBank(
   ahl_tclBaseOneThreadService* pService,
   GuiService& guiService)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_TUNERSELECTBAND_MEMBANK, pService)
   , _guiService(guiService)
{
}


/**************************************************************************//**
 * Destructor
 ******************************************************************************/
clSDS_Method_TunerSelectBandMemBank::~clSDS_Method_TunerSelectBandMemBank()
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
tVoid clSDS_Method_TunerSelectBandMemBank::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   vActivateTunerSource(oMessage.Band);
   vSendMethodResult();
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_TunerSelectBandMemBank::vActivateTunerSource(const sds2hmi_fi_tcl_e8_TUN_Band& band)
{
   switch (band.enType)
   {
      case sds2hmi_fi_tcl_e8_TUN_Band::FI_EN_FM:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SDS_PLAY_FM);
         _guiService.sendActivateAudioSourceSignal(AudioSource__FM);
         break;

      case sds2hmi_fi_tcl_e8_TUN_Band::FI_EN_AM_MW:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SDS_PLAY_AM);
         _guiService.sendActivateAudioSourceSignal(AudioSource__AM);
         break;

      case sds2hmi_fi_tcl_e8_TUN_Band::FI_EN_XM:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SDS_PLAY_XM);
         _guiService.sendActivateAudioSourceSignal(AudioSource__XM);
         break;

      case sds2hmi_fi_tcl_e8_TUN_Band::FI_EN_DAB:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SDS_PLAY_DAB);
         _guiService.sendActivateAudioSourceSignal(AudioSource__DAB);
         break;

      default:
         break;
   }
}
