/**************************************************************************//**
 * \file       clSDS_Method_PhoneSelectPhone.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_PhoneSelectPhone_h
#define clSDS_Method_PhoneSelectPhone_h


#include "MOST_Tel_FIProxy.h"
#include "external/sds2hmi_fi.h"
#include "Sds2HmiServer/framework/clServerMethod.h"
#include "application/clSDS_PhoneStatusObserver.h"


class GuiService;


class clSDS_Method_PhoneSelectPhone
   : public clServerMethod
   , public MOST_Tel_FI::SetActivePhoneCallbackIF
   , public clSDS_PhoneStatusObserver
{
   public:
      virtual ~clSDS_Method_PhoneSelectPhone();
      clSDS_Method_PhoneSelectPhone(ahl_tclBaseOneThreadService* pService,
                                    boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > pTelProxy,
                                    GuiService& guiService);

      virtual void onSetActivePhoneError(const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& proxy,
                                         const ::boost::shared_ptr< MOST_Tel_FI::SetActivePhoneError >& error);

      virtual void onSetActivePhoneResult(const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& proxy,
                                          const ::boost::shared_ptr< MOST_Tel_FI::SetActivePhoneResult >& result);

      virtual void multiPointPairingEnabled(bool multiPointPairingStatus);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      void handleMethodStart(sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart& oMessage);

      GuiService& _guiService;
      boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy > _telephoneProxy;
      bool _multiPointPairing;
};


#endif
