/**************************************************************************//**
 * \file       clSDS_Method_PhoneRedialLastNumber.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_PhoneRedialLastNumber_h
#define clSDS_Method_PhoneRedialLastNumber_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "MOST_Tel_FIProxy.h"
#include "SdsAdapter_Trace.h"
#include "application/clSDS_RecentCallsList.h"


class clSDS_RecentCallsList;
class AudioSourceHandler;
class GuiService;

class clSDS_Method_PhoneRedialLastNumber
   : public clServerMethod
   , public asf::core::ServiceAvailableIF
   , public MOST_Tel_FI::DialCallbackIF
{
   public:
      virtual ~clSDS_Method_PhoneRedialLastNumber();
      clSDS_Method_PhoneRedialLastNumber(
         ahl_tclBaseOneThreadService* pService,
         clSDS_RecentCallsList* pRecentCallsList,
         ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > pTelProxy,
         AudioSourceHandler* pAudioSourceHandler,
         GuiService& guiService);

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      // callbacks by DialCallbackIF from Tel FI
      virtual void onDialError(
         const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_Tel_FI::DialError >& error);
      virtual void onDialResult(
         const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_Tel_FI::DialResult >& result);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      clSDS_RecentCallsList* _pRecentCallsList;
      boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy > _telephoneProxy;
      void dialNumber(std::string oLastDialedNumber);
      AudioSourceHandler* _pAudioSourceHandler;
      GuiService& _guiService;
};


#endif
