/**************************************************************************//**
 * \file       clSDS_Method_NaviStartGuidance.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NaviStartGuidance_h
#define clSDS_Method_NaviStartGuidance_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "application/GuiService.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"


class clSDS_NaviListItems;


class clSDS_Method_NaviStartGuidance
   : public clServerMethod
   , public org::bosch::cm::navigation::NavigationService::StartGuidanceCallbackIF
   , public org::bosch::cm::navigation::NavigationService::StartGuidanceToHomeLocationCallbackIF
   , public org::bosch::cm::navigation::NavigationService::StartGuidanceToWorkLocationCallbackIF
{
   public:
      virtual ~clSDS_Method_NaviStartGuidance();
      clSDS_Method_NaviStartGuidance(
         ahl_tclBaseOneThreadService* pService,
         GuiService& guiService,
         clSDS_NaviListItems* pNaviListItems,
         ::boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> pNaviProxy);

      virtual void onStartGuidanceError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceError >& error);
      virtual void onStartGuidanceResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceResponse >& response);

      virtual void onStartGuidanceToHomeLocationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceToHomeLocationError >& error);
      virtual void onStartGuidanceToHomeLocationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceToHomeLocationResponse >& response);

      virtual void onStartGuidanceToWorkLocationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceToWorkLocationError >& error);
      virtual void onStartGuidanceToWorkLocationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceToWorkLocationResponse >& response);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      clSDS_NaviListItems* _pNaviListItems;
      GuiService& _guiService;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _navigationProxy;
};


#endif
