/**************************************************************************//**
 * \file       clSDS_Method_NaviStartDistanceDetour.cpp
 *
 * clSDS_Method_NaviStartDistanceDetour  class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_NaviStartDistanceDetour.h"


using namespace org::bosch::cm::navigation::NavigationService;


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_NaviStartDistanceDetour::clSDS_Method_NaviStartDistanceDetour(
   ahl_tclBaseOneThreadService* pService,
   ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy,
   NaviDetourList* pDetourList)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVISTARTDISTANCEDETOUR, pService)
   , _pNaviProxy(naviProxy)
   , _pDetourList(pDetourList)
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_NaviStartDistanceDetour::~clSDS_Method_NaviStartDistanceDetour()
{
}


/***********************************************************************//**
 *
 ***************************************************************************/
tVoid clSDS_Method_NaviStartDistanceDetour::vMethodStart(amt_tclServiceData* pInMsg)
{
   sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart oMessage;
   vGetDataFromAmt(pInMsg, oMessage);
   if (_pDetourList != NULL)
   {
      unsigned long index = _pDetourList->getIndexForDistance(oMessage.Distance.szValue, oMessage.Unit.enType);
      _pNaviProxy->sendSelectJamAheadListEntryRequest(*this, index);
   }
   vSendMethodResult();
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_NaviStartDistanceDetour::onSelectJamAheadListEntryError(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryError >& /*error*/)
{
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_NaviStartDistanceDetour::onSelectJamAheadListEntryResponse(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryResponse >& /*response*/)
{
}
